/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractSimpleTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.HasRange;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractPropertyRangeTranslator<Axiom extends OWLAxiom & HasRange<? extends OWLObject>, P extends OntProperty>
extends AbstractSimpleTranslator<Axiom> {
    @Override
    public void write(Axiom axiom, OntModel graph) {
        WriteHelper.writeTriple(graph, ((HasProperty)axiom).getProperty(), RDFS.range, ((HasRange)axiom).getRange(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicate(model, RDFS.range).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, AxiomsSettings config) {
        return statement.getSubject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return RDFS.range.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    @Override
    Triple createSearchTriple(Axiom axiom) {
        Node subject = TranslateHelper.getSearchNode(((HasProperty)axiom).getProperty());
        if (subject == null) {
            return null;
        }
        Node object = TranslateHelper.getSearchNode(((HasRange)axiom).getRange());
        if (object == null) {
            return null;
        }
        return Triple.create((Node)subject, (Node)RDFS.range.asNode(), (Node)object);
    }

    protected static abstract class RangeAxiomImpl<A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression, R extends OWLObject>
    extends ONTAxiomImpl<A>
    implements WithTwoObjects<P, R> {
        protected RangeAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected RangeAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public P getProperty() {
            return (P)((OWLPropertyExpression)this.getONTSubject().getOWLObject());
        }

        public R getRange() {
            return (R)this.getONTObject().getOWLObject();
        }
    }
}

