/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractSimpleTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithOneObject;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;

public abstract class AbstractPropertyTypeTranslator<Axiom extends OWLAxiom & HasProperty<? extends OWLObject>, P extends OntProperty>
extends AbstractSimpleTranslator<Axiom> {
    abstract Resource getType();

    abstract Class<P> getView();

    P getSubject(OntStatement s) {
        return (P)((OntProperty)s.getSubject(this.getView()));
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicateAndObject(model, RDF.type, (RDFNode)this.getType()).filterKeep(s -> s.getSubject().canAs(this.getView()));
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return statement.getObject().equals(this.getType()) && statement.isDeclaration() && statement.getSubject().canAs(this.getView());
    }

    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, ((HasProperty)axiom).getProperty(), RDF.type, (RDFNode)this.getType(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    boolean testSearchTriple(Triple t) {
        return t.getSubject().isURI();
    }

    @Override
    Triple createSearchTriple(Axiom axiom) {
        Node n = TranslateHelper.getSearchNode(((HasProperty)axiom).getProperty());
        if (n == null) {
            return null;
        }
        return Triple.create((Node)n, (Node)RDF.type.asNode(), (Node)this.getType().asNode());
    }

    protected static abstract class UnaryAxiomImpl<A extends OWLUnaryPropertyAxiom<P>, P extends OWLPropertyExpression>
    extends ONTAxiomImpl<A>
    implements WithOneObject<P> {
        protected UnaryAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public final P getProperty() {
            return (P)((OWLPropertyExpression)this.getONTValue().getOWLObject());
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }
    }

    protected static abstract class ObjectAxiomImpl<A extends OWLObjectPropertyCharacteristicAxiom>
    extends UnaryAxiomImpl<A, OWLObjectPropertyExpression> {
        protected ObjectAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> findURISubject(ModelObjectFactory factory) {
            return factory.getObjectProperty((String)this.subject);
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> fetchONTSubject(OntStatement statement, ModelObjectFactory factory) {
            return factory.getProperty(statement.getSubject(OntObjectProperty.class));
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return false;
        }

        Set<OWLObjectProperty> getComponentsAsPropertySet() {
            return this.getOWLComponentsAsSet();
        }

        Set<OWLEntity> getComponentsAsEntitySet() {
            return this.getOWLComponentsAsSet();
        }

        boolean hasSubject(OWLObjectProperty property) {
            return this.subject.equals(ONTEntityImpl.getURI((OWLEntity)property));
        }
    }
}

