/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractSimpleTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractSubPropertyTranslator<Axiom extends OWLAxiom, P extends OntProperty>
extends AbstractSimpleTranslator<Axiom> {
    abstract OWLPropertyExpression getSubProperty(Axiom var1);

    abstract OWLPropertyExpression getSuperProperty(Axiom var1);

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicate(model, RDFS.subPropertyOf).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, AxiomsSettings config) {
        return statement.getSubject().canAs(this.getView()) && statement.getObject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return RDFS.subPropertyOf.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, (OWLObject)this.getSubProperty(axiom), RDFS.subPropertyOf, (OWLObject)this.getSuperProperty(axiom), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    Triple createSearchTriple(Axiom axiom) {
        Node subject = TranslateHelper.getSearchNode((OWLObject)this.getSubProperty(axiom));
        if (subject == null) {
            return null;
        }
        Node object = TranslateHelper.getSearchNode((OWLObject)this.getSuperProperty(axiom));
        if (object == null) {
            return null;
        }
        return Triple.create((Node)subject, (Node)RDFS.subPropertyOf.asNode(), (Node)object);
    }

    public static abstract class SubPropertyAxiomImpl<A extends OWLAxiom, P extends OWLPropertyExpression>
    extends ONTAxiomImpl<A>
    implements WithTwoObjects.Unary<P> {
        protected SubPropertyAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected SubPropertyAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public P getSubProperty() {
            return (P)((OWLPropertyExpression)this.getONTSubject().getOWLObject());
        }

        public P getSuperProperty() {
            return (P)((OWLPropertyExpression)this.getONTObject().getOWLObject());
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return false;
        }

        @Override
        public final boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }
    }
}

