/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractNaryTranslator;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class AbstractTwoWayNaryTranslator<Axiom extends OWLAxiom & OWLNaryAxiom<OWL>, OWL extends OWLObject & IsAnonymous, ONT extends OntObject>
extends AbstractNaryTranslator<Axiom, OWL, ONT> {
    @Override
    public void write(Axiom axiom, OntModel model) {
        List operands = ((HasOperands)axiom).getOperandsAsList();
        List annotations = axiom.annotationsAsList();
        if (operands.isEmpty() && annotations.isEmpty()) {
            LOGGER.warn("Nothing to write, wrong axiom is given: {}", axiom);
            return;
        }
        if (operands.size() == 2) {
            this.write((OWLNaryAxiom)axiom, annotations, model);
        } else {
            Resource root = model.createResource();
            model.add(root, RDF.type, (RDFNode)this.getMembersType());
            model.add(root, this.getMembersPredicate(), (RDFNode)WriteHelper.addRDFList(model, operands));
            OntDisjoint res = (OntDisjoint)root.as(this.getDisjointView());
            WriteHelper.addAnnotations(res, (Collection<OWLAnnotation>)annotations);
        }
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return super.listStatements(model, config).andThen(this.listDisjointStatements(model));
    }

    private ExtendedIterator<OntStatement> listDisjointStatements(OntModel model) {
        return OntModels.listLocalObjects(model, this.getDisjointView()).mapWith(OntObject::getMainStatement);
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return super.testStatement(statement, config) || RDF.type.equals(statement.getPredicate()) && statement.getSubject().canAs(this.getDisjointView());
    }

    abstract Resource getMembersType();

    abstract Property getMembersPredicate();

    abstract Class<? extends OntDisjoint<ONT>> getDisjointView();

    @Override
    protected ExtendedIterator<OntStatement> listSearchStatements(Axiom key, OntModel model, AxiomsSettings config) {
        Collection<Triple> search = this.getSearchTriples(key);
        if (search.isEmpty()) {
            return this.listStatements(model, config);
        }
        return this.listSearchStatements(model, search).andThen(this.listDisjointStatements(model));
    }

    ONTObject<Axiom> makeAxiom(OntStatement statement, Collection<ONTObject<OWLAnnotation>> annotations, Function<ONT, ONTObject<? extends OWL>> membersExtractor, BiFunction<Collection<ONTObject<? extends OWL>>, Collection<ONTObject<OWLAnnotation>>, Axiom> creator) {
        Collection members;
        OntObject subject = statement.getSubject();
        OntDisjoint disjoint = null;
        if (subject.canAs(this.getDisjointView())) {
            disjoint = (OntDisjoint)subject.as(this.getDisjointView());
            members = disjoint.members().map(membersExtractor).collect(Collectors.toSet());
        } else {
            members = Stream.of(subject, statement.getObject()).map(r -> (OntObject)r.as(this.getView())).map(membersExtractor).collect(Collectors.toSet());
        }
        OWLAxiom axiom = (OWLAxiom)creator.apply(members, annotations);
        return (disjoint != null ? ONTWrapperImpl.create(axiom, disjoint) : ONTWrapperImpl.create(axiom, statement)).append(annotations).append(members);
    }
}

