/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.axioms.AbstractListBasedTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithList;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class DisjointUnionTranslator
extends AbstractListBasedTranslator<OWLDisjointUnionAxiom, OntClass.Named, OWLClassExpression, OntClass, OWLClassExpression> {
    @Override
    public OWLObject getSubject(OWLDisjointUnionAxiom axiom) {
        return axiom.getOWLClass();
    }

    @Override
    public Property getPredicate() {
        return OWL.disjointUnionOf;
    }

    @Override
    public Collection<? extends OWLObject> getObjects(OWLDisjointUnionAxiom axiom) {
        return axiom.getOperandsAsList();
    }

    @Override
    Class<OntClass.Named> getView() {
        return OntClass.Named.class;
    }

    @Override
    public ONTObject<OWLDisjointUnionAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLDisjointUnionAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        return this.makeAxiom(statement, factory::getClass, OntClass.Named::findDisjointUnion, factory::getClass, Collectors.toSet(), (s, m) -> factory.getOWLDataFactory().getOWLDisjointUnionAxiom(((OWLClassExpression)s.getOWLObject()).asOWLClass(), TranslateHelper.toSet(m), TranslateHelper.toSet(factory.getAnnotations(statement, config))));
    }

    public static class AxiomImpl
    extends AbstractListBasedTranslator.WithListImpl<OWLDisjointUnionAxiom, OntClass>
    implements WithList.Sorted<OWLDisjointUnionAxiom, OWLClass, OWLClassExpression>,
    OWLDisjointUnionAxiom {
        private static final BiFunction<Triple, Supplier<OntModel>, AxiomImpl> FACTORY = AxiomImpl::new;

        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected AxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return WithList.Sorted.create(statement, FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected OntList<OntClass> findList(OntStatement statement) {
            return statement.getSubject(OntClass.Named.class).findDisjointUnion((RDFNode)statement.getObject(RDFList.class)).orElseThrow(() -> new OntApiException.IllegalState("Can't find []-list in " + statement));
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLClassExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return OntModels.listMembers(this.findList(statement)).mapWith(factory::getClass);
        }

        public OWLClass getOWLClass() {
            return (OWLClass)this.getONTSubject().getOWLObject();
        }

        public Stream<OWLClassExpression> classExpressions() {
            return this.operands();
        }

        public Stream<OWLClassExpression> operands() {
            return this.members().map(ONTObject::getOWLObject);
        }

        @Override
        public ONTObject fromContentItem(Object x, ModelObjectFactory factory) {
            return x instanceof String ? this.findSubjectByURI((String)x, factory) : (ONTObject<OWLClass>)x;
        }

        @Override
        public ONTObject<OWLClass> findSubjectByURI(String uri, ModelObjectFactory factory) {
            return factory.getClass(uri);
        }

        @Override
        public ONTObject<OWLClass> fetchONTSubject(OntStatement statement, ModelObjectFactory factory) {
            return this.findSubjectByURI(statement.getSubject().getURI(), factory);
        }

        protected AxiomImpl makeCopy(final ONTObject<OWLDisjointUnionAxiom> other) {
            return new AxiomImpl(this.subject, this.predicate, this.object, this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
        }

        @Override
        protected OWLDisjointUnionAxiom createAnnotatedAxiom(Object[] content, ModelObjectFactory factory, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLDisjointUnionAxiom(this.getFactoryClass(content, factory), this.getFactoryMembers(content, factory), annotations);
        }

        public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom() {
            DataFactory df = this.getDataFactory();
            ModelObjectFactory factory = this.getObjectFactory();
            Object[] content = this.getContent();
            return df.getOWLEquivalentClassesAxiom((OWLClassExpression)this.getFactoryClass(content, factory), (OWLClassExpression)df.getOWLObjectUnionOf(this.getFactoryMembers(content, factory)));
        }

        public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom() {
            return this.getDataFactory().getOWLDisjointClassesAxiom(this.getFactoryMembers(this.getContent(), this.getObjectFactory()));
        }

        protected List<OWLClassExpression> getFactoryMembers(Object[] content, ModelObjectFactory factory) {
            return this.members(content, factory).map(x -> (OWLClassExpression)AxiomImpl.eraseModel(x.getOWLObject())).collect(Collectors.toList());
        }

        protected OWLClass getFactoryClass(Object[] content, ModelObjectFactory factory) {
            return (OWLClass)AxiomImpl.eraseModel(this.findONTSubject(content[0], factory).getOWLObject());
        }
    }
}

