/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.axioms.AbstractNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.owlapi.axioms.OWLEquivalentClassesAxiomImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class EquivalentClassesTranslator
extends AbstractNaryTranslator<OWLEquivalentClassesAxiom, OWLClassExpression, OntClass> {
    @Override
    public Property getPredicate() {
        return OWL.equivalentClass;
    }

    @Override
    Class<OntClass> getView() {
        return OntClass.class;
    }

    @Override
    public ONTObject<OWLEquivalentClassesAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLEquivalentClassesAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<? extends OWLClassExpression> a = factory.getClass(statement.getSubject(this.getView()));
        ONTObject<? extends OWLClassExpression> b = factory.getClass((OntClass)statement.getObject().as(this.getView()));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLEquivalentClassesAxiom res = factory.getOWLDataFactory().getOWLEquivalentClassesAxiom(a.getOWLObject(), b.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(a).append(b);
    }

    @Override
    Triple getONTSearchTriple(OWLEquivalentClassesAxiom axiom) {
        Triple res = super.getONTSearchTriple(axiom);
        return res != null && TranslateHelper.isGoodSearchTriple(res) ? res : null;
    }

    @Override
    Triple createSearchTriple(OWLObject subject, OWLObject object) {
        Node left = TranslateHelper.getSearchNodeOrANY(subject);
        Node right = TranslateHelper.getSearchNodeOrANY(object);
        Triple res = Triple.create((Node)left, (Node)this.getPredicate().asNode(), (Node)right);
        return TranslateHelper.isGoodSearchTriple(res) ? res : null;
    }

    public static abstract class AxiomImpl
    extends AbstractNaryTranslator.ClassNaryAxiomImpl<OWLEquivalentClassesAxiom>
    implements OWLEquivalentClassesAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            this(AxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), AxiomImpl.strip(t.getObject()), m);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithManyObjects.create(statement, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected final long count() {
            return 2L;
        }

        public Stream<OWLClass> namedClasses() {
            return this.classExpressions().filter(OWLEquivalentClassesAxiomImpl::isNamed).map(AsOWLClass::asOWLClass);
        }

        public boolean containsNamedEquivalentClass() {
            return this.members().map(ONTObject::getOWLObject).anyMatch(OWLEquivalentClassesAxiomImpl::isNamed);
        }

        public boolean containsOWLNothing() {
            return this.members().map(ONTObject::getOWLObject).anyMatch(OWLClassExpression::isOWLNothing);
        }

        public boolean containsOWLThing() {
            return this.members().map(ONTObject::getOWLObject).anyMatch(OWLClassExpression::isOWLThing);
        }

        @Override
        protected OWLEquivalentClassesAxiom createAxiom(Collection<OWLClassExpression> members, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLEquivalentClassesAxiom(members, annotations == null ? NO_ANNOTATIONS : annotations);
        }

        @Override
        protected OWLSubClassOfAxiom createSubClassOf(OWLClassExpression a, OWLClassExpression b) {
            return this.getDataFactory().getOWLSubClassOfAxiom(a, b);
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithManyObjects.Complex<ComplexImpl, OWLClassExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            protected ComplexImpl makeCopyWith(final ONTObject<OWLEquivalentClassesAxiom> other) {
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                return res;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithManyObjects.Simple<OWLClassExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            protected SimpleImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            private static boolean isNonBuiltin(String uri) {
                return !uri.equals(OWL.Thing.getURI()) && !uri.equals(OWL.Nothing.getURI());
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof SimpleImpl && this.isReverseTriple((SimpleImpl)other);
            }

            protected AxiomImpl makeCopyWith(final ONTObject<OWLEquivalentClassesAxiom> other) {
                if (other instanceof SimpleImpl) {
                    final Triple t = ((SimpleImpl)other).asTriple();
                    return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                        @Override
                        public Stream<Triple> triples() {
                            return Stream.concat(this.triples(), Stream.of(t));
                        }
                    };
                }
                return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
            }

            @Override
            public boolean containsNamedEquivalentClass() {
                return SimpleImpl.isNonBuiltin((String)this.subject) || SimpleImpl.isNonBuiltin((String)this.object);
            }

            @Override
            public boolean containsOWLNothing() {
                return this.hasURIResource(OWL.Nothing);
            }

            @Override
            public boolean containsOWLThing() {
                return this.hasURIResource(OWL.Thing);
            }

            @Override
            public Set<OWLClass> getNamedClassSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLClassExpression> getClassExpressionSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsNamedClass(OWLClass clazz) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)clazz));
            }

            @Override
            public boolean canContainDatatypes() {
                return false;
            }

            @Override
            public boolean canContainNamedIndividuals() {
                return false;
            }

            @Override
            public boolean canContainDataProperties() {
                return false;
            }

            @Override
            public boolean canContainObjectProperties() {
                return false;
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }
        }
    }
}

