/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.axioms.AbstractNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;

public class EquivalentDataPropertiesTranslator
extends AbstractNaryTranslator<OWLEquivalentDataPropertiesAxiom, OWLDataPropertyExpression, OntDataProperty> {
    @Override
    Property getPredicate() {
        return OWL.equivalentProperty;
    }

    @Override
    Class<OntDataProperty> getView() {
        return OntDataProperty.class;
    }

    @Override
    public ONTObject<OWLEquivalentDataPropertiesAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLEquivalentDataPropertiesAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<OWLDataProperty> a = factory.getProperty(statement.getSubject(this.getView()));
        ONTObject<OWLDataProperty> b = factory.getProperty((OntDataProperty)statement.getObject().as(this.getView()));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLEquivalentDataPropertiesAxiom res = factory.getOWLDataFactory().getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)a.getOWLObject(), (OWLDataPropertyExpression)b.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(a).append(b);
    }

    public static abstract class AxiomImpl
    extends AbstractNaryTranslator.DataPropertyNaryAxiomImpl<OWLEquivalentDataPropertiesAxiom>
    implements OWLEquivalentDataPropertiesAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            this(AxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), AxiomImpl.strip(t.getObject()), m);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithManyObjects.create(statement, SimpleImpl.FACTORY, WithAnnotationsImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected final long count() {
            return 2L;
        }

        @Override
        protected OWLEquivalentDataPropertiesAxiom createAxiom(Collection<OWLDataPropertyExpression> members, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLEquivalentDataPropertiesAxiom(members, annotations == null ? NO_ANNOTATIONS : annotations);
        }

        protected OWLSubDataPropertyOfAxiom createSubPropertyOf(OWLDataPropertyExpression a, OWLDataPropertyExpression b) {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubDataPropertyOfAxiom(a, b);
        }

        public Collection<OWLSubDataPropertyOfAxiom> asSubDataPropertyOfAxioms() {
            return this.walkAllPairwise((a, b) -> this.createSubPropertyOf(AxiomImpl.eraseModel(a), AxiomImpl.eraseModel(b)));
        }

        public static class WithAnnotationsImpl
        extends AxiomImpl
        implements WithManyObjects.Complex<WithAnnotationsImpl, OWLDataPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, WithAnnotationsImpl> FACTORY = WithAnnotationsImpl::new;
            protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

            public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
                this(WithAnnotationsImpl.strip(t.getSubject()), t.getPredicate().getURI(), WithAnnotationsImpl.strip(t.getObject()), m);
            }

            protected WithAnnotationsImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof WithAnnotationsImpl && Arrays.equals(this.getContent(), ((WithAnnotationsImpl)other).getContent());
            }

            @Override
            public boolean isAnnotated() {
                return true;
            }

            protected WithAnnotationsImpl makeCopyWith(final ONTObject<OWLEquivalentDataPropertiesAxiom> other) {
                WithAnnotationsImpl res = new WithAnnotationsImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                return res;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithManyObjects.Simple<OWLDataPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            protected SimpleImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof SimpleImpl && this.isReverseTriple((SimpleImpl)other);
            }

            protected AxiomImpl makeCopyWith(final ONTObject<OWLEquivalentDataPropertiesAxiom> other) {
                if (other instanceof SimpleImpl) {
                    final Triple t = ((SimpleImpl)other).asTriple();
                    return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                        @Override
                        public Stream<Triple> triples() {
                            return Stream.concat(this.triples(), Stream.of(t));
                        }
                    };
                }
                return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
            }

            @Override
            public Set<OWLDataProperty> getDataPropertySet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsDataProperty(OWLDataProperty property) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)property));
            }
        }
    }
}

