/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.axioms.AbstractListBasedTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithList;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public class HasKeyTranslator
extends AbstractListBasedTranslator<OWLHasKeyAxiom, OntClass, OWLClassExpression, OntRealProperty, OWLPropertyExpression> {
    @Override
    OWLObject getSubject(OWLHasKeyAxiom axiom) {
        return axiom.getClassExpression();
    }

    @Override
    Property getPredicate() {
        return OWL.hasKey;
    }

    @Override
    Collection<? extends OWLObject> getObjects(OWLHasKeyAxiom axiom) {
        return axiom.getOperandsAsList();
    }

    @Override
    Class<OntClass> getView() {
        return OntClass.class;
    }

    @Override
    public ONTObject<OWLHasKeyAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLHasKeyAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        return this.makeAxiom(statement, factory::getClass, OntClass::findHasKey, factory::getProperty, Collectors.toSet(), (s, m) -> factory.getOWLDataFactory().getOWLHasKeyAxiom((OWLClassExpression)s.getOWLObject(), TranslateHelper.toSet(m), TranslateHelper.toSet(factory.getAnnotations(statement, config))));
    }

    public static class AxiomImpl
    extends AbstractListBasedTranslator.WithListImpl<OWLHasKeyAxiom, OntRealProperty>
    implements WithList.Sorted<OWLHasKeyAxiom, OWLClassExpression, OWLPropertyExpression>,
    OWLHasKeyAxiom {
        private static final BiFunction<Triple, Supplier<OntModel>, AxiomImpl> FACTORY = AxiomImpl::new;

        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected AxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return WithList.Sorted.create(statement, FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected OntList<OntRealProperty> findList(OntStatement statement) {
            return statement.getSubject(OntClass.class).findHasKey((RDFNode)statement.getObject(RDFList.class)).orElseThrow(() -> new OntApiException.IllegalState("Can't find []-list in " + statement));
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLPropertyExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return OntModels.listMembers(this.findList(statement)).mapWith(factory::getProperty);
        }

        public OWLClassExpression getClassExpression() {
            return (OWLClassExpression)this.getONTSubject().getOWLObject();
        }

        public Stream<OWLPropertyExpression> propertyExpressions() {
            return this.operands();
        }

        public Stream<OWLPropertyExpression> operands() {
            return this.members().map(ONTObject::getOWLObject);
        }

        @Override
        public ONTObject fromContentItem(Object x, ModelObjectFactory factory) {
            return (ONTObject)x;
        }

        @Override
        public Object toContentItem(ONTObject x) {
            return x;
        }

        @Override
        public ONTObject<? extends OWLClassExpression> findSubjectByURI(String uri, ModelObjectFactory factory) {
            return factory.getClass(uri);
        }

        @Override
        public ONTObject<? extends OWLClassExpression> fetchONTSubject(OntStatement statement, ModelObjectFactory factory) {
            return factory.getClass(statement.getSubject(OntClass.class));
        }

        protected AxiomImpl makeCopy(final ONTObject<OWLHasKeyAxiom> other) {
            return new AxiomImpl(this.subject, this.predicate, this.object, this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
        }

        @Override
        protected OWLHasKeyAxiom createAnnotatedAxiom(Object[] content, ModelObjectFactory factory, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLHasKeyAxiom((OWLClassExpression)AxiomImpl.eraseModel(this.findONTSubject(content[0], factory).getOWLObject()), this.members(content, factory).map(x -> (OWLPropertyExpression)AxiomImpl.eraseModel(x.getOWLObject())).collect(Collectors.toList()), annotations);
        }
    }
}

