/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractSimpleTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;

public class InverseObjectPropertiesTranslator
extends AbstractSimpleTranslator<OWLInverseObjectPropertiesAxiom> {
    @Override
    public void write(OWLInverseObjectPropertiesAxiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, (OWLObject)axiom.getFirstProperty(), OWL.inverseOf, (OWLObject)axiom.getSecondProperty(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicate(model, OWL.inverseOf).filterDrop(s -> s.getSubject().isAnon() && s.getObject().isURIResource());
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        if (!OWL.inverseOf.equals(statement.getPredicate())) {
            return false;
        }
        if (statement.getSubject().isAnon() && statement.getObject().isURIResource()) {
            return false;
        }
        return statement.getSubject().canAs(OntObjectProperty.class) && statement.getObject().canAs(OntObjectProperty.class);
    }

    @Override
    public ONTObject<OWLInverseObjectPropertiesAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLInverseObjectPropertiesAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<? extends OWLObjectPropertyExpression> f = factory.getProperty(statement.getSubject(OntObjectProperty.class));
        ONTObject<? extends OWLObjectPropertyExpression> s = factory.getProperty(statement.getObject(OntObjectProperty.class));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLInverseObjectPropertiesAxiom res = factory.getOWLDataFactory().getOWLInverseObjectPropertiesAxiom(f.getOWLObject(), s.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(f).append(s);
    }

    @Override
    Triple createSearchTriple(OWLInverseObjectPropertiesAxiom axiom) {
        Node subject = TranslateHelper.getSearchNode((OWLObject)axiom.getFirstProperty());
        if (subject == null) {
            return null;
        }
        Node object = TranslateHelper.getSearchNode((OWLObject)axiom.getSecondProperty());
        if (object == null) {
            return null;
        }
        return Triple.create((Node)subject, (Node)OWL.inverseOf.asNode(), (Node)object);
    }

    @ParametersAreNonnullByDefault
    public static abstract class AxiomImpl
    extends ONTAxiomImpl<OWLInverseObjectPropertiesAxiom>
    implements WithManyObjects<OWLObjectPropertyExpression>,
    OWLInverseObjectPropertiesAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            this(AxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), AxiomImpl.strip(t.getObject()), m);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithManyObjects.create(statement, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        public abstract ONTObject<? extends OWLObjectPropertyExpression> getFirstONTProperty();

        public abstract ONTObject<? extends OWLObjectPropertyExpression> getSecondONTProperty();

        public OWLObjectPropertyExpression getFirstProperty() {
            return this.getFirstONTProperty().getOWLObject();
        }

        public OWLObjectPropertyExpression getSecondProperty() {
            return this.getSecondONTProperty().getOWLObject();
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getObjectProperty(uri);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLObjectPropertyExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return Iter.of(new ONTObject[]{factory.getProperty(statement.getSubject(OntObjectProperty.class)), factory.getProperty(statement.getObject(OntObjectProperty.class))});
        }

        public Stream<OWLObjectPropertyExpression> properties() {
            return this.sorted().map(ONTObject::getOWLObject);
        }

        public Set<OWLObjectPropertyExpression> getPropertiesMinus(OWLObjectPropertyExpression property) {
            return this.getSetMinus((OWLObject[])new OWLObjectPropertyExpression[]{property});
        }

        public Collection<OWLInverseObjectPropertiesAxiom> asPairwiseAxioms() {
            return AxiomImpl.createSet(this.eraseModel());
        }

        public Collection<OWLInverseObjectPropertiesAxiom> splitToAnnotatedPairs() {
            return AxiomImpl.createSet(this.eraseModel());
        }

        public Collection<OWLSubObjectPropertyOfAxiom> asSubObjectPropertyOfAxioms() {
            OWLObjectPropertyExpression first = AxiomImpl.eraseModel(this.getFirstProperty());
            OWLObjectPropertyExpression second = AxiomImpl.eraseModel(this.getSecondProperty());
            HashSet<OWLSubObjectPropertyOfAxiom> res = new HashSet<OWLSubObjectPropertyOfAxiom>();
            DataFactory df = this.getDataFactory();
            res.add(df.getOWLSubObjectPropertyOfAxiom(first, second.getInverseProperty()));
            res.add(df.getOWLSubObjectPropertyOfAxiom(second, first.getInverseProperty()));
            return res;
        }

        @Override
        protected OWLInverseObjectPropertiesAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLInverseObjectPropertiesAxiom(AxiomImpl.eraseModel(this.getFirstProperty()), AxiomImpl.eraseModel(this.getSecondProperty()), annotations);
        }

        @Override
        public boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public AxiomImpl merge(ONTObject<OWLInverseObjectPropertiesAxiom> other) {
            if (this == other) {
                return this;
            }
            if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                return this;
            }
            AxiomImpl res = this.makeCopyWith(other);
            res.hashCode = this.hashCode;
            return res;
        }

        abstract AxiomImpl makeCopyWith(ONTObject<OWLInverseObjectPropertiesAxiom> var1);

        protected static class ComplexImpl
        extends AxiomImpl
        implements WithManyObjects.Complex<ComplexImpl, OWLObjectPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            public ONTObject<? extends OWLObjectPropertyExpression> getFirstONTProperty() {
                if (this.subject instanceof String) {
                    return this.findByURI((String)this.subject, this.getObjectFactory());
                }
                Object[] content = this.getContent();
                return (ONTObject)content[0];
            }

            @Override
            public ONTObject<? extends OWLObjectPropertyExpression> getSecondONTProperty() {
                Object[] content;
                if (this.object instanceof String) {
                    return this.findByURI((String)this.object, this.getObjectFactory());
                }
                return (ONTObject)content[(content = this.getContent()).length == 1 ? 0 : 1];
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            @Override
            ComplexImpl makeCopyWith(final ONTObject<OWLInverseObjectPropertiesAxiom> other) {
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                return res;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithManyObjects.Simple<OWLObjectPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            protected SimpleImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public ONTObject<? extends OWLObjectPropertyExpression> getFirstONTProperty() {
                return this.findByURI((String)this.subject, this.getObjectFactory());
            }

            @Override
            public ONTObject<? extends OWLObjectPropertyExpression> getSecondONTProperty() {
                return this.findByURI((String)this.object, this.getObjectFactory());
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof SimpleImpl && this.subject.equals(((AxiomImpl)other).getObjectURI()) && this.object.equals(((AxiomImpl)other).getSubjectURI());
            }

            @Override
            public Set<OWLObjectProperty> getObjectPropertySet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsObjectProperty(OWLObjectProperty property) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)property));
            }

            @Override
            AxiomImpl makeCopyWith(final ONTObject<OWLInverseObjectPropertiesAxiom> other) {
                if (other instanceof SimpleImpl) {
                    final Triple t = ((SimpleImpl)other).asTriple();
                    return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                        @Override
                        public Stream<Triple> triples() {
                            return Stream.concat(this.triples(), Stream.of(t));
                        }
                    };
                }
                return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
            }
        }
    }
}

