/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractNegativePropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithAssertion;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class NegativeDataPropertyAssertionTranslator
extends AbstractNegativePropertyAssertionTranslator<OWLNegativeDataPropertyAssertionAxiom, OntNegativeAssertion.WithDataProperty> {
    @Override
    OntNegativeAssertion.WithDataProperty createNPA(OWLNegativeDataPropertyAssertionAxiom axiom, OntModel model) {
        return WriteHelper.addDataProperty(model, (OWLDataPropertyExpression)axiom.getProperty()).addNegativeAssertion(WriteHelper.addIndividual(model, axiom.getSubject()), WriteHelper.addLiteral(model, (OWLLiteral)axiom.getObject()));
    }

    @Override
    Class<OntNegativeAssertion.WithDataProperty> getView() {
        return OntNegativeAssertion.WithDataProperty.class;
    }

    @Override
    public ONTObject<OWLNegativeDataPropertyAssertionAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLNegativeDataPropertyAssertionAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        OntNegativeAssertion.WithDataProperty npa = statement.getSubject(this.getView());
        ONTObject<? extends OWLIndividual> s = factory.getIndividual(npa.getSource());
        ONTObject<OWLDataProperty> p = factory.getProperty((OntDataProperty)npa.getProperty());
        ONTObject<OWLLiteral> o = factory.getLiteral((Literal)npa.getTarget());
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLNegativeDataPropertyAssertionAxiom res = factory.getOWLDataFactory().getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)p.getOWLObject(), s.getOWLObject(), o.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, npa).append(annotations).append(s).append(p).append(o);
    }

    public static class AxiomImpl
    extends AbstractNegativePropertyAssertionTranslator.NegativeAssertionImpl<OntNegativeAssertion.WithDataProperty, OWLNegativeDataPropertyAssertionAxiom, OWLDataPropertyExpression, OWLLiteral>
    implements OWLNegativeDataPropertyAssertionAxiom {
        private static final BiFunction<Triple, Supplier<OntModel>, AxiomImpl> FACTORY = AxiomImpl::new;

        public AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return WithAssertion.create(statement, FACTORY, SET_HASH_CODE, factory, config);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        @Override
        public Class<OntNegativeAssertion.WithDataProperty> getType() {
            return OntNegativeAssertion.WithDataProperty.class;
        }

        @Override
        public Object fromObject(ONTObject o) {
            return OWLLiteralImpl.asONT((OWLLiteral)o.getOWLObject()).getLiteralLabel();
        }

        @Override
        public ONTObject<? extends OWLLiteral> toObject(Object o, ModelObjectFactory factory) {
            return factory.getLiteral((LiteralLabel)o);
        }

        @Override
        public Object fromPredicate(ONTObject o) {
            OWLDataProperty property = (OWLDataProperty)o.getOWLObject();
            return ONTEntityImpl.getURI((OWLEntity)property);
        }

        @Override
        public ONTObject<? extends OWLDataProperty> toPredicate(Object p, ModelObjectFactory factory) {
            return factory.getDataProperty((String)p);
        }

        @Override
        public ONTObject<? extends OWLDataProperty> fetchONTPredicate(OntStatement statement, ModelObjectFactory factory) {
            return factory.getProperty((OntDataProperty)((OntNegativeAssertion.WithDataProperty)this.getResource(statement)).getProperty());
        }

        @Override
        public ONTObject<? extends OWLLiteral> fetchONTObject(OntStatement statement, ModelObjectFactory factory) {
            return factory.getLiteral((Literal)((OntNegativeAssertion.WithDataProperty)this.getResource(statement)).getTarget());
        }

        public boolean containsAnonymousIndividuals() {
            return this.getContent()[0] instanceof BlankNodeId;
        }

        public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)this.getFSubject()}), (OWLClassExpression)df.getOWLObjectComplementOf((OWLClassExpression)df.getOWLDataHasValue((OWLDataPropertyExpression)this.getFPredicate(), (OWLLiteral)this.getFObject())));
        }

        @Override
        protected OWLNegativeDataPropertyAssertionAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            DataFactory df = this.getDataFactory();
            return df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.getFPredicate(), (OWLIndividual)this.getFSubject(), (OWLLiteral)this.getFObject(), annotations);
        }

        protected AxiomImpl makeCopy(final ONTObject<OWLNegativeDataPropertyAssertionAxiom> other) {
            return new AxiomImpl(this.subject, this.predicate, this.object, this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public Set<OWLDataProperty> getDataPropertySet() {
            return AxiomImpl.createSet(((OWLDataPropertyExpression)this.getProperty()).asOWLDataProperty());
        }

        @Override
        public boolean containsDataProperty(OWLDataProperty property) {
            return ((OWLDataPropertyExpression)this.getProperty()).equals(property);
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            Object[] content = this.getContent();
            if (content[0] instanceof String) {
                Set<OWLNamedIndividual> res = AxiomImpl.createSortedSet();
                res.add(this.toNamedIndividual((String)content[0], this.getObjectFactory()).getOWLObject());
                return res;
            }
            return AxiomImpl.createSet();
        }

        @Override
        public boolean containsNamedIndividual(OWLNamedIndividual individual) {
            Object[] content = this.getContent();
            return content[0] instanceof String && content[0].equals(ONTEntityImpl.getURI((OWLEntity)individual));
        }
    }
}

