/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithAssertion;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class ObjectPropertyAssertionTranslator
extends AbstractPropertyAssertionTranslator<OWLObjectPropertyExpression, OWLObjectPropertyAssertionAxiom> {
    @Override
    public void write(OWLObjectPropertyAssertionAxiom axiom, OntModel model) {
        OWLIndividual s = axiom.getSubject();
        OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)axiom.getProperty();
        OWLIndividual o = (OWLIndividual)axiom.getObject();
        WriteHelper.writeAssertionTriple(model, (OWLObject)(p.isAnonymous() ? o : s), (OWLPropertyExpression)(p.isAnonymous() ? p.getInverseProperty() : p), (OWLObject)(p.isAnonymous() ? s : o), axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listStatements(model).filterKeep(s -> this.testStatement((OntStatement)s, config));
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return statement.getPredicate().canAs(OntObjectProperty.Named.class) && statement.getSubject().canAs(OntIndividual.class) && statement.getObject().canAs(OntIndividual.class);
    }

    @Override
    public ONTObject<OWLObjectPropertyAssertionAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLObjectPropertyAssertionAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<? extends OWLIndividual> subject = factory.getIndividual(statement.getSubject(OntIndividual.class));
        ONTObject<? extends OWLObjectPropertyExpression> property = factory.getProperty((OntObjectProperty)statement.getPredicate().as(OntObjectProperty.class));
        ONTObject<? extends OWLIndividual> object = factory.getIndividual(statement.getObject(OntIndividual.class));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLObjectPropertyAssertionAxiom res = factory.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom(property.getOWLObject(), subject.getOWLObject(), object.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(subject).append(property).append(object);
    }

    @Override
    Triple createSearchTriple(OWLObjectPropertyAssertionAxiom axiom) {
        Node subject = TranslateHelper.getSearchNode((OWLObject)axiom.getSubject());
        if (subject == null) {
            return null;
        }
        Node object = TranslateHelper.getSearchNode((OWLObject)axiom.getObject());
        if (object == null) {
            return null;
        }
        Node property = WriteHelper.toNode((HasIRI)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        return Triple.create((Node)subject, (Node)property, (Node)object);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyAssertionTranslator.AssertionImpl<OWLObjectPropertyAssertionAxiom, OWLIndividual, OWLObjectPropertyExpression, OWLIndividual>
    implements OWLObjectPropertyAssertionAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithAssertion.create(statement, SimpleImpl.FACTORY, WithAnnotationsImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        public boolean isInSimplifiedForm() {
            return true;
        }

        @Override
        public ONTObject<? extends OWLIndividual> findONTSubject(ModelObjectFactory factory) {
            return this.findByURIOrBlankId(this.subject, factory);
        }

        @Override
        public ONTObject<? extends OWLIndividual> findONTObject(ModelObjectFactory factory) {
            return this.findByURIOrBlankId(this.object, factory);
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> findONTPredicate(ModelObjectFactory factory) {
            return this.findONTProperty(factory);
        }

        public ONTObject<OWLObjectProperty> findONTProperty(ModelObjectFactory factory) {
            return factory.getObjectProperty(this.predicate);
        }

        public OWLObjectPropertyAssertionAxiom getSimplified() {
            return (OWLObjectPropertyAssertionAxiom)this.eraseModel();
        }

        @Override
        protected OWLObjectPropertyAssertionAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.getFPredicate(), (OWLIndividual)this.getFSubject(), (OWLIndividual)this.getFObject(), annotations);
        }

        public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)this.getFSubject()}), (OWLClassExpression)df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.getFPredicate(), (OWLIndividual)this.getFObject()));
        }

        @Override
        public boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public Set<OWLObjectProperty> getObjectPropertySet() {
            return AxiomImpl.createSet(((OWLObjectPropertyExpression)this.getProperty()).asOWLObjectProperty());
        }

        @Override
        public boolean containsObjectProperty(OWLObjectProperty property) {
            return this.predicate.equals(ONTEntityImpl.getURI((OWLEntity)property));
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            Set<OWLNamedIndividual> res = AxiomImpl.createSortedSet();
            this.collectNamedIndividuals(res, null);
            return res;
        }

        protected void collectNamedIndividuals(Set res, ModelObjectFactory factory) {
            if (this.subject instanceof String) {
                res.add((factory == null ? (factory = this.getObjectFactory()) : factory).getNamedIndividual((String)this.subject).getOWLObject());
            }
            if (this.object instanceof String) {
                res.add((factory == null ? this.getObjectFactory() : factory).getNamedIndividual((String)this.object).getOWLObject());
            }
        }

        public static class WithAnnotationsImpl
        extends AxiomImpl
        implements WithAssertion.WithAnnotations<WithAnnotationsImpl, OWLIndividual, OWLObjectPropertyExpression, OWLIndividual> {
            private static final BiFunction<Triple, Supplier<OntModel>, WithAnnotationsImpl> FACTORY = WithAnnotationsImpl::new;
            protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

            public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
                return this.content;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithAssertion.Simple<OWLIndividual, OWLObjectPropertyExpression, OWLIndividual> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
                Set<OWLAnonymousIndividual> res = SimpleImpl.createSortedSet();
                ModelObjectFactory f = null;
                if (this.subject instanceof BlankNodeId) {
                    f = this.getObjectFactory();
                    res.add(f.getAnonymousIndividual((BlankNodeId)this.subject).getOWLObject());
                }
                if (this.object instanceof BlankNodeId) {
                    res.add((f == null ? this.getObjectFactory() : f).getAnonymousIndividual((BlankNodeId)this.object).getOWLObject());
                }
                return res;
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                Set<OWLEntity> res = SimpleImpl.createSortedSet();
                ModelObjectFactory factory = this.getObjectFactory();
                res.add((OWLEntity)this.findONTProperty(factory).getOWLObject());
                this.collectNamedIndividuals(res, factory);
                return res;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean containsNamedIndividual(OWLNamedIndividual individual) {
                String uri = null;
                if (this.hasURISubject()) {
                    uri = ONTEntityImpl.getURI((OWLEntity)individual);
                    if (this.getSubjectURI().equals(uri)) return true;
                }
                if (!this.hasURIObject()) return false;
                if (!this.getObjectURI().equals(uri == null ? ONTEntityImpl.getURI((OWLEntity)individual) : uri)) return false;
                return true;
            }
        }
    }
}

