/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.axioms.AbstractNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class SameIndividualTranslator
extends AbstractNaryTranslator<OWLSameIndividualAxiom, OWLIndividual, OntIndividual> {
    private static final Property PREDICATE = OWL.sameAs;

    @Override
    public Property getPredicate() {
        return PREDICATE;
    }

    @Override
    Class<OntIndividual> getView() {
        return OntIndividual.class;
    }

    @Override
    Triple getONTSearchTriple(OWLSameIndividualAxiom axiom) {
        return axiom instanceof WithTriple ? ((WithTriple)axiom).asTriple() : null;
    }

    @Override
    public ONTObject<OWLSameIndividualAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLSameIndividualAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<? extends OWLIndividual> a = factory.getIndividual(statement.getSubject(this.getView()));
        ONTObject<? extends OWLIndividual> b = factory.getIndividual((OntIndividual)statement.getObject().as(this.getView()));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLSameIndividualAxiom res = factory.getOWLDataFactory().getOWLSameIndividualAxiom(a.getOWLObject(), b.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(a).append(b);
    }

    public static abstract class AxiomImpl
    extends AbstractNaryTranslator.IndividualNaryAxiomImpl<OWLSameIndividualAxiom>
    implements OWLSameIndividualAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            this(AxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), AxiomImpl.strip(t.getObject()), m);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithManyObjects.create(statement, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected final long count() {
            return 2L;
        }

        public boolean containsAnonymousIndividuals() {
            return this.individuals().anyMatch(IsAnonymous::isAnonymous);
        }

        @Override
        protected OWLSameIndividualAxiom createAxiom(Collection<OWLIndividual> members, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLSameIndividualAxiom(members, annotations == null ? NO_ANNOTATIONS : annotations);
        }

        @Override
        protected OWLSubClassOfAxiom createSubClassOf(OWLIndividual a, OWLIndividual b) {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{a}), (OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{b}));
        }

        @Override
        public Collection<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
            return this.fromPairs((a, b) -> this.createSubClassOf(AxiomImpl.eraseModel(a), AxiomImpl.eraseModel(b))).collect(Collectors.toSet());
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithManyObjects.Complex<ComplexImpl, OWLIndividual> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            protected ComplexImpl makeCopyWith(final ONTObject<OWLSameIndividualAxiom> other) {
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                return res;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithManyObjects.Simple<OWLIndividual> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            protected SimpleImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof SimpleImpl && this.isReverseTriple((SimpleImpl)other);
            }

            protected AxiomImpl makeCopyWith(final ONTObject<OWLSameIndividualAxiom> other) {
                if (other instanceof SimpleImpl) {
                    final Triple t = ((SimpleImpl)other).asTriple();
                    return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                        @Override
                        public Stream<Triple> triples() {
                            return Stream.concat(this.triples(), Stream.of(t));
                        }
                    };
                }
                return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
            }

            @Override
            public boolean containsAnonymousIndividuals() {
                return false;
            }

            @Override
            public Set<OWLNamedIndividual> getNamedIndividualSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsNamedIndividual(OWLNamedIndividual individual) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)individual));
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }
        }
    }
}

