/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractSubPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;

public class SubAnnotationPropertyOfTranslator
extends AbstractSubPropertyTranslator<OWLSubAnnotationPropertyOfAxiom, OntAnnotationProperty> {
    @Override
    OWLPropertyExpression getSubProperty(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom.getSubProperty();
    }

    @Override
    OWLPropertyExpression getSuperProperty(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom.getSuperProperty();
    }

    @Override
    Class<OntAnnotationProperty> getView() {
        return OntAnnotationProperty.class;
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        if (!config.isLoadAnnotationAxioms()) {
            return NullIterator.instance();
        }
        return super.listStatements(model, config);
    }

    @Override
    protected boolean filter(OntStatement statement, AxiomsSettings config) {
        return super.filter(statement, config) && ReadHelper.testAnnotationAxiomOverlaps(statement, config, (AxiomType<? extends OWLObjectPropertyAxiom>)AxiomType.SUB_OBJECT_PROPERTY, (AxiomType<? extends OWLDataPropertyAxiom>)AxiomType.SUB_DATA_PROPERTY);
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return config.isLoadAnnotationAxioms() && super.testStatement(statement, config);
    }

    @Override
    public ONTObject<OWLSubAnnotationPropertyOfAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLSubAnnotationPropertyOfAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<OWLAnnotationProperty> sub = factory.getProperty(statement.getSubject(OntAnnotationProperty.class));
        ONTObject<OWLAnnotationProperty> sup = factory.getProperty((OntAnnotationProperty)statement.getObject().as(OntAnnotationProperty.class));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLSubAnnotationPropertyOfAxiom res = factory.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(sub.getOWLObject(), sup.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(sub).append(sup);
    }

    public static abstract class AxiomImpl
    extends AbstractSubPropertyTranslator.SubPropertyAxiomImpl<OWLSubAnnotationPropertyOfAxiom, OWLAnnotationProperty>
    implements OWLSubAnnotationPropertyOfAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithTwoObjects.create(statement, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        public ONTObject<? extends OWLAnnotationProperty> subjectFromStatement(OntStatement statement, ModelObjectFactory factory) {
            return factory.getProperty(statement.getSubject(OntAnnotationProperty.class));
        }

        @Override
        public ONTObject<? extends OWLAnnotationProperty> objectFromStatement(OntStatement statement, ModelObjectFactory factory) {
            return factory.getProperty(statement.getObject(OntAnnotationProperty.class));
        }

        @Override
        public ONTObject<? extends OWLAnnotationProperty> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getAnnotationProperty(uri);
        }

        @Override
        protected OWLSubAnnotationPropertyOfAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLSubAnnotationPropertyOfAxiom((OWLAnnotationProperty)AxiomImpl.eraseModel(this.getSubProperty()), (OWLAnnotationProperty)AxiomImpl.eraseModel(this.getSuperProperty()), annotations);
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithTwoObjects.UnaryWithContent<ComplexImpl, OWLAnnotationProperty> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithTwoObjects.UnarySimple<OWLAnnotationProperty> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsAnnotationProperty(OWLAnnotationProperty property) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)property));
            }
        }
    }
}

