/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class SubClassOfTranslator
extends AxiomTranslator<OWLSubClassOfAxiom> {
    @Override
    public void write(OWLSubClassOfAxiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, (OWLObject)axiom.getSubClass(), RDFS.subClassOf, (OWLObject)axiom.getSuperClass(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicate(model, RDFS.subClassOf).filterKeep(this::filter);
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return statement.getPredicate().equals(RDFS.subClassOf) && this.filter(statement);
    }

    public boolean filter(Statement s) {
        return s.getSubject().canAs(OntClass.class) && s.getObject().canAs(OntClass.class);
    }

    @Override
    public ONTObject<OWLSubClassOfAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLSubClassOfAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<? extends OWLClassExpression> sub = factory.getClass(statement.getSubject(OntClass.class));
        ONTObject<? extends OWLClassExpression> sup = factory.getClass((OntClass)statement.getObject().as(OntClass.class));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLSubClassOfAxiom res = factory.getOWLDataFactory().getOWLSubClassOfAxiom(sub.getOWLObject(), sup.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(sub).append(sup);
    }

    @Override
    protected final Collection<Triple> getSearchTriples(OWLSubClassOfAxiom axiom) {
        Triple res = this.getSearchTriple(axiom);
        return TranslateHelper.isGoodSearchTriple(res) ? Collections.singleton(res) : Collections.emptySet();
    }

    private Triple getSearchTriple(OWLSubClassOfAxiom axiom) {
        if (axiom instanceof WithTriple) {
            return TranslateHelper.toSearchTriple(((WithTriple)axiom).asTriple());
        }
        Node subject = TranslateHelper.getSearchNodeOrANY((OWLObject)axiom.getSubClass());
        Node object = TranslateHelper.getSearchNodeOrANY((OWLObject)axiom.getSuperClass());
        return Triple.create((Node)subject, (Node)RDFS.subClassOf.asNode(), (Node)object);
    }

    public static abstract class AxiomImpl
    extends ONTAxiomImpl<OWLSubClassOfAxiom>
    implements WithTwoObjects.Unary<OWLClassExpression>,
    OWLSubClassOfAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected AxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithTwoObjects.create(statement, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected OWLSubClassOfAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLSubClassOfAxiom(AxiomImpl.eraseModel(this.getSubClass()), AxiomImpl.eraseModel(this.getSuperClass()), annotations);
        }

        public OWLClassExpression getSubClass() {
            return (OWLClassExpression)this.getONTSubject().getOWLObject();
        }

        public OWLClassExpression getSuperClass() {
            return (OWLClassExpression)this.getONTObject().getOWLObject();
        }

        @Override
        public ONTObject<? extends OWLClassExpression> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getClass(uri);
        }

        @Override
        public ONTObject<? extends OWLClassExpression> subjectFromStatement(OntStatement statement, ModelObjectFactory factory) {
            return factory.getClass(statement.getSubject(OntClass.class));
        }

        @Override
        public ONTObject<? extends OWLClassExpression> objectFromStatement(OntStatement statement, ModelObjectFactory factory) {
            return factory.getClass(statement.getObject(OntClass.class));
        }

        public boolean isGCI() {
            return this.getSubClass().isAnonymous();
        }

        @Override
        public boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithTwoObjects.UnaryWithContent<ComplexImpl, OWLClassExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                if (this.hasURISubject() && !this.sameSubject(other)) {
                    return false;
                }
                if (this.hasURIObject() && !this.sameObject(other)) {
                    return false;
                }
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            @Override
            protected boolean sameAs(ONTStatementImpl other) {
                if (this.notSame(other)) {
                    return false;
                }
                return this.sameContent(other);
            }

            @Override
            public ONTObject<OWLSubClassOfAxiom> merge(final ONTObject<OWLSubClassOfAxiom> other) {
                if (this == other) {
                    return this;
                }
                if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                    return this;
                }
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                res.hashCode = this.hashCode;
                return res;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithTwoObjects.UnarySimple<OWLClassExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return false;
            }

            @Override
            public Set<OWLClass> getNamedClassSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLClassExpression> getClassExpressionSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsNamedClass(OWLClass clazz) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)clazz));
            }

            @Override
            public boolean canContainDatatypes() {
                return false;
            }

            @Override
            public boolean canContainNamedIndividuals() {
                return false;
            }

            @Override
            public boolean canContainDataProperties() {
                return false;
            }

            @Override
            public boolean canContainObjectProperties() {
                return false;
            }

            @Override
            public boolean canContainAnnotationProperties() {
                return false;
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }
        }
    }
}

