/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.axioms.AbstractListBasedTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithList;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;

public class SubPropertyChainOfTranslator
extends AbstractListBasedTranslator<OWLSubPropertyChainOfAxiom, OntObjectProperty, OWLObjectPropertyExpression, OntObjectProperty, OWLObjectPropertyExpression> {
    @Override
    OWLObject getSubject(OWLSubPropertyChainOfAxiom axiom) {
        return axiom.getSuperProperty();
    }

    @Override
    Property getPredicate() {
        return OWL.propertyChainAxiom;
    }

    @Override
    Collection<? extends OWLObject> getObjects(OWLSubPropertyChainOfAxiom axiom) {
        return axiom.getPropertyChain();
    }

    @Override
    Class<OntObjectProperty> getView() {
        return OntObjectProperty.class;
    }

    @Override
    public ONTObject<OWLSubPropertyChainOfAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLSubPropertyChainOfAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        return this.makeAxiom(statement, factory::getProperty, OntObjectProperty::findPropertyChain, factory::getProperty, Collectors.toList(), (s, m) -> factory.getOWLDataFactory().getOWLSubPropertyChainOfAxiom(m.stream().map(ONTObject::getOWLObject).collect(Collectors.toList()), (OWLObjectPropertyExpression)s.getOWLObject(), TranslateHelper.toSet(factory.getAnnotations(statement, config))));
    }

    public static class AxiomImpl
    extends AbstractListBasedTranslator.WithListImpl<OWLSubPropertyChainOfAxiom, OntObjectProperty>
    implements WithList.Sequent<OWLSubPropertyChainOfAxiom, OWLObjectPropertyExpression, OWLObjectPropertyExpression>,
    OWLSubPropertyChainOfAxiom {
        private static final BiFunction<Triple, Supplier<OntModel>, AxiomImpl> FACTORY = AxiomImpl::new;

        public AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected AxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        protected OntList<OntObjectProperty> findList(OntStatement statement) {
            return statement.getSubject(OntObjectProperty.class).findPropertyChain((RDFNode)statement.getObject(RDFList.class)).orElseThrow(() -> new OntApiException.IllegalState("Can't find []-list in " + statement));
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLObjectPropertyExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return OntModels.listMembers(this.findList(statement)).mapWith(factory::getProperty);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return WithList.Sequent.create(statement, FACTORY, SET_HASH_CODE, factory, config);
        }

        public List<OWLObjectPropertyExpression> getPropertyChain() {
            return this.members().map(ONTObject::getOWLObject).collect(Collectors.toList());
        }

        public OWLObjectPropertyExpression getSuperProperty() {
            return (OWLObjectPropertyExpression)this.getONTSubject().getOWLObject();
        }

        @Override
        public ONTObject fromContentItem(Object x, ModelObjectFactory factory) {
            return x instanceof String ? this.findPropertyByURI((String)x, factory) : (ONTObject<OWLObjectProperty>)x;
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> findSubjectByURI(String uri, ModelObjectFactory factory) {
            return this.findPropertyByURI(uri, factory);
        }

        private ONTObject<OWLObjectProperty> findPropertyByURI(String uri, ModelObjectFactory factory) {
            return factory.getObjectProperty(uri);
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> fetchONTSubject(OntStatement statement, ModelObjectFactory factory) {
            return factory.getProperty(statement.getSubject(OntObjectProperty.class));
        }

        @Override
        protected OWLSubPropertyChainOfAxiom createAnnotatedAxiom(Object[] content, ModelObjectFactory factory, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLSubPropertyChainOfAxiom(this.members(content, factory).map(x -> (OWLObjectPropertyExpression)AxiomImpl.eraseModel(x.getOWLObject())).collect(Collectors.toList()), (OWLObjectPropertyExpression)AxiomImpl.eraseModel(this.findONTSubject(content[0], factory).getOWLObject()), annotations);
        }

        public boolean isEncodingOfTransitiveProperty() {
            return this.isEncodingOfTransitiveProperty(this.getContent(), this.getObjectFactory());
        }

        protected boolean isEncodingOfTransitiveProperty(Object[] content, ModelObjectFactory factory) {
            if (content.length < 3) {
                return false;
            }
            List members = this.members(content, factory).collect(Collectors.toList());
            if (members.size() != 2) {
                return false;
            }
            ONTObject subject = this.findONTSubject(content[0], factory);
            return subject.equals(members.get(0)) && subject.equals(members.get(1));
        }

        public AxiomImpl makeCopy(final ONTObject<OWLSubPropertyChainOfAxiom> other) {
            return new AxiomImpl(this.subject, this.predicate, this.object, this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
        }

        @Override
        public final boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainDataProperties() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }
    }
}

