/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyTypeTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithOneObject;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;

public class SymmetricObjectPropertyTranslator
extends AbstractPropertyTypeTranslator<OWLSymmetricObjectPropertyAxiom, OntObjectProperty> {
    @Override
    Resource getType() {
        return OWL.SymmetricProperty;
    }

    @Override
    Class<OntObjectProperty> getView() {
        return OntObjectProperty.class;
    }

    @Override
    public ONTObject<OWLSymmetricObjectPropertyAxiom> toAxiomImpl(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
        return AxiomImpl.create(statement, factory, config);
    }

    @Override
    public ONTObject<OWLSymmetricObjectPropertyAxiom> toAxiomWrap(OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        ONTObject<? extends OWLObjectPropertyExpression> p = factory.getProperty((OntObjectProperty)this.getSubject(statement));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLSymmetricObjectPropertyAxiom res = factory.getOWLDataFactory().getOWLSymmetricObjectPropertyAxiom(p.getOWLObject(), TranslateHelper.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(p);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyTypeTranslator.ObjectAxiomImpl<OWLSymmetricObjectPropertyAxiom>
    implements OWLSymmetricObjectPropertyAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, ModelObjectFactory factory, AxiomsSettings config) {
            return (AxiomImpl)WithOneObject.create(statement, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        public Set<OWLSubObjectPropertyOfAxiom> asSubPropertyAxioms() {
            DataFactory df = this.getDataFactory();
            HashSet<OWLSubObjectPropertyOfAxiom> res = new HashSet<OWLSubObjectPropertyOfAxiom>(2);
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)AxiomImpl.eraseModel(this.getProperty());
            res.add(df.getOWLSubObjectPropertyOfAxiom(p, p.getInverseProperty(), NO_ANNOTATIONS));
            res.add(df.getOWLSubObjectPropertyOfAxiom(p.getInverseProperty(), p, NO_ANNOTATIONS));
            return res;
        }

        @Override
        protected OWLSymmetricObjectPropertyAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)AxiomImpl.eraseModel(this.getProperty()), annotations);
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithOneObject.Complex<ComplexImpl, OWLObjectPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            @Override
            public ONTObject<OWLSymmetricObjectPropertyAxiom> merge(final ONTObject<OWLSymmetricObjectPropertyAxiom> other) {
                if (this == other) {
                    return this;
                }
                if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                    return this;
                }
                ComplexImpl res = new ComplexImpl(this.asTriple(), this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                res.hashCode = this.hashCode;
                return res;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithOneObject.Simple<OWLObjectPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLObjectProperty> getObjectPropertySet() {
                return this.getComponentsAsPropertySet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getComponentsAsEntitySet();
            }

            @Override
            public boolean containsObjectProperty(OWLObjectProperty property) {
                return this.hasSubject(property);
            }
        }
    }
}

