/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

public class TranslateHelper {
    public static <X extends OWLObject> Set<X> toSet(Collection<? extends ONTObject<? extends X>> objects) {
        return TranslateHelper.objects(objects).collect(Collectors.toSet());
    }

    public static <X extends OWLObject> Stream<X> objects(Collection<? extends ONTObject<? extends X>> objects) {
        return objects.stream().map(ONTObject::getOWLObject);
    }

    public static Node getSearchNode(OWLObject obj) {
        if (obj.isIRI()) {
            return WriteHelper.toNode((IRI)obj);
        }
        if (obj instanceof HasIRI) {
            return WriteHelper.toNode((HasIRI)obj);
        }
        if (obj instanceof OWLAnonymousIndividual) {
            return WriteHelper.toNode((OWLAnonymousIndividual)obj);
        }
        if (obj instanceof OWLLiteral) {
            return WriteHelper.toNode((OWLLiteral)obj);
        }
        return null;
    }

    static Node getSearchNodeOrANY(OWLObject obj) {
        Node res = TranslateHelper.getSearchNode(obj);
        return res == null ? Node.ANY : res;
    }

    static Triple toSearchTriple(Triple t) {
        return Graphs.isNamedTriple(t) ? t : Triple.create((Node)TranslateHelper.uriOrANY(t.getSubject()), (Node)t.getPredicate(), (Node)TranslateHelper.uriOrANY(t.getObject()));
    }

    static boolean isGoodSearchTriple(Triple t) {
        return t.getSubject() != Node.ANY || t.getObject() != Node.ANY;
    }

    private static Node uriOrANY(Node n) {
        return n.isURI() ? n : Node.ANY;
    }
}

