/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.HasSubject;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

interface WithAssertion<S extends OWLObject, P extends OWLObject, O extends OWLObject>
extends WithTriple,
HasSubject<S>,
HasProperty<P> {
    public ONTObject<? extends S> findONTSubject(ModelObjectFactory var1);

    public ONTObject<? extends P> findONTPredicate(ModelObjectFactory var1);

    public ONTObject<? extends O> findONTObject(ModelObjectFactory var1);

    default public ONTObject<? extends S> fetchONTSubject(OntStatement statement, ModelObjectFactory factory) {
        return this.findONTSubject(factory);
    }

    default public ONTObject<? extends P> fetchONTPredicate(OntStatement statement, ModelObjectFactory factory) {
        return this.findONTPredicate(factory);
    }

    default public ONTObject<? extends O> fetchONTObject(OntStatement statement, ModelObjectFactory factory) {
        return this.findONTObject(factory);
    }

    default public S getSubject() {
        return this.getONTSubject().getOWLObject();
    }

    default public P getProperty() {
        return this.getONTPredicate().getOWLObject();
    }

    default public O getValue() {
        return this.getONTObject().getOWLObject();
    }

    default public ONTObject<? extends S> getONTSubject() {
        return this.findONTSubject(this.getObjectFactory());
    }

    default public ONTObject<? extends P> getONTPredicate() {
        return this.findONTPredicate(this.getObjectFactory());
    }

    default public ONTObject<? extends O> getONTObject() {
        return this.findONTObject(this.getObjectFactory());
    }

    default public S getFSubject() {
        return ONTObjectImpl.eraseModel(this.getSubject());
    }

    default public P getFPredicate() {
        return ONTObjectImpl.eraseModel(this.getProperty());
    }

    default public O getFObject() {
        return ONTObjectImpl.eraseModel(this.getValue());
    }

    @Override
    default public Set<? extends OWLObject> getOWLComponentsAsSet(ModelObjectFactory factory) {
        Set res = OWLObjectImpl.createSortedSet();
        res.add(this.findONTSubject(factory).getOWLObject());
        res.add(this.findONTPredicate(factory).getOWLObject());
        res.add(this.findONTObject(factory).getOWLObject());
        return res;
    }

    @Override
    default public Stream<ONTObject<? extends OWLObject>> objects() {
        ModelObjectFactory factory = this.getObjectFactory();
        return Stream.of(this.findONTSubject(factory), this.findONTPredicate(factory), this.findONTObject(factory));
    }

    public static <R extends ONTObject & WithAssertion> R create(OntStatement statement, BiFunction<Triple, Supplier<OntModel>, ? extends R> simple, BiFunction<Triple, Supplier<OntModel>, ? extends R> complex, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
        ONTObject s = (ONTObject)simple.apply(statement.asTriple(), factory.model());
        Object[] content = WithAnnotations.initContent((WithAssertion)((Object)s), statement, setHash, factory, config);
        if (content == null) {
            return (R)s;
        }
        ONTObject c = (ONTObject)complex.apply(statement.asTriple(), factory.model());
        setHash.accept((OWLAxiom)c, s.hashCode());
        ((WithContent)((Object)c)).putContent(content);
        return (R)c;
    }

    public static <R extends ONTObject & Complex> R create(OntStatement statement, BiFunction<Triple, Supplier<OntModel>, ? extends R> maker, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
        ONTObject res = (ONTObject)maker.apply(statement.asTriple(), factory.model());
        Object[] content = Complex.initContent((Complex)((Object)res), statement, setHash, factory, config);
        ((WithContent)((Object)res)).putContent(content);
        return (R)res;
    }

    public static interface Complex<A extends OWLAxiom, S extends OWLObject, P extends OWLObject, O extends OWLObject>
    extends WithAssertion<S, P, O>,
    WithContent<A> {
        public static Object[] initContent(Complex axiom, OntStatement statement, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            Object[] res = new Object[annotations.size() + 3];
            int hash = axiom.hashIndex();
            ONTObject s = axiom.fetchONTSubject(statement, factory);
            ONTObject p = axiom.fetchONTPredicate(statement, factory);
            ONTObject o = axiom.fetchONTObject(statement, factory);
            hash = OWLObject.hashIteration((int)hash, (int)s.hashCode());
            hash = OWLObject.hashIteration((int)hash, (int)p.hashCode());
            hash = OWLObject.hashIteration((int)hash, (int)o.hashCode());
            int i = 0;
            res[i++] = axiom.fromSubject(s);
            res[i++] = axiom.fromPredicate(p);
            res[i++] = axiom.fromObject(o);
            int h = 1;
            for (ONTObject<OWLAnnotation> a : annotations) {
                res[i++] = a;
                h = WithContent.hashIteration(h, a.hashCode());
            }
            setHash.accept(axiom, OWLObject.hashIteration((int)hash, (int)h));
            return res;
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            ModelObjectFactory factory = this.getObjectFactory();
            InternalConfig config = this.getConfig();
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            Object[] res = new Object[annotations.size() + 3];
            int i = 0;
            res[i++] = this.fromSubject(this.fetchONTSubject(statement, factory));
            res[i++] = this.fromPredicate(this.fetchONTPredicate(statement, factory));
            res[i++] = this.fromObject(this.fetchONTObject(statement, factory));
            for (ONTObject<OWLAnnotation> a : annotations) {
                res[i++] = a;
            }
            return res;
        }

        public Object fromSubject(ONTObject var1);

        public Object fromObject(ONTObject var1);

        public Object fromPredicate(ONTObject var1);

        public ONTObject<? extends S> toSubject(Object var1, ModelObjectFactory var2);

        public ONTObject<? extends P> toPredicate(Object var1, ModelObjectFactory var2);

        public ONTObject<? extends O> toObject(Object var1, ModelObjectFactory var2);

        @Override
        default public ONTObject<? extends S> findONTSubject(ModelObjectFactory factory) {
            return this.toSubject(this.getContent()[0], factory);
        }

        @Override
        default public ONTObject<? extends P> findONTPredicate(ModelObjectFactory factory) {
            return this.toPredicate(this.getContent()[1], factory);
        }

        @Override
        default public ONTObject<? extends O> findONTObject(ModelObjectFactory factory) {
            return this.toObject(this.getContent()[2], factory);
        }

        @Override
        default public boolean isAnnotated() {
            return this.getContent().length > 3;
        }

        @Override
        default public Stream<OWLAnnotation> annotations() {
            return this.annotations(this.getContent());
        }

        @Override
        default public List<OWLAnnotation> annotationsAsList() {
            return this.annotations().collect(Collectors.toList());
        }

        default public Stream<OWLAnnotation> annotations(Object[] content) {
            Stream<Object> res = Arrays.stream(content).skip(3L);
            return res;
        }

        default public Stream<ONTObject<? extends OWLObject>> objects(Object[] content, ModelObjectFactory factory) {
            return Stream.of(this.toSubject(content[0], factory), this.toPredicate(content[1], factory), this.toObject(content[2], factory));
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            Object[] content = this.getContent();
            ModelObjectFactory factory = this.getObjectFactory();
            Stream<OWLAnnotation> res = Stream.concat(this.objects(content, factory), this.annotations(content));
            return res;
        }

        @Override
        default public Set<? extends OWLObject> getOWLComponentsAsSet(ModelObjectFactory factory) {
            return this.getOWLComponentsAsSet(this.getContent(), factory);
        }

        default public Set<? extends OWLObject> getOWLComponentsAsSet(Object[] content, ModelObjectFactory factory) {
            Set res = OWLObjectImpl.createSortedSet();
            this.objects(content, factory).map(ONTObject::getOWLObject).forEach(res::add);
            return res;
        }
    }

    public static interface WithAnnotations<A extends OWLAxiom, S extends OWLObject, P extends OWLObject, O extends OWLObject>
    extends WithAssertion<S, P, O>,
    WithContent<A> {
        public static Object[] initContent(WithAssertion axiom, OntStatement statement, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
            int hash = OWLObject.hashIteration((int)axiom.hashIndex(), (int)axiom.fetchONTSubject(statement, factory).hashCode());
            hash = OWLObject.hashIteration((int)hash, (int)axiom.fetchONTPredicate(statement, factory).hashCode());
            hash = OWLObject.hashIteration((int)hash, (int)axiom.fetchONTObject(statement, factory).hashCode());
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            Object[] res = new Object[annotations.size()];
            int h = 1;
            int index = 0;
            for (ONTObject<OWLAnnotation> a : annotations) {
                res[index++] = a;
                h = WithContent.hashIteration(h, a.hashCode());
            }
            setHash.accept(axiom, OWLObject.hashIteration((int)hash, (int)h));
            return res.length == 0 ? null : res;
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            ModelObjectFactory factory = this.getObjectFactory();
            InternalConfig config = this.getConfig();
            return ONTAxiomImpl.collectAnnotations(statement, factory, config).toArray();
        }

        @Override
        default public boolean isAnnotated() {
            return true;
        }

        @Override
        default public Stream<OWLAnnotation> annotations() {
            return ONTAnnotationImpl.contentAsStream(this.getContent());
        }

        @Override
        default public List<OWLAnnotation> annotationsAsList() {
            return ONTAnnotationImpl.contentAsList(this.getContent());
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            Stream<OWLAnnotation> res = Stream.concat(WithAssertion.super.objects(), this.annotations());
            return res;
        }
    }

    public static interface Simple<S extends OWLObject, P extends OWLObject, O extends OWLObject>
    extends WithAssertion<S, P, O>,
    WithoutAnnotations {
        @Override
        default public boolean isAnnotated() {
            return false;
        }
    }
}

