/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.WithList;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

interface WithManyObjects<E extends OWLObject>
extends WithTriple {
    public ONTObject<? extends E> findByURI(String var1, ModelObjectFactory var2);

    public ExtendedIterator<ONTObject<? extends E>> listONTComponents(OntStatement var1, ModelObjectFactory var2);

    public Stream<ONTObject<? extends E>> sorted(ModelObjectFactory var1);

    public Stream<ONTObject<? extends E>> members(ModelObjectFactory var1);

    public Stream<ONTObject<? extends OWLObject>> objects(ModelObjectFactory var1);

    default public Set<ONTObject<? extends E>> fetchONTComponents(OntStatement statement, ModelObjectFactory factory) {
        return Iter.addAll(this.listONTComponents(statement, factory), ONTObjectImpl.createContentSet());
    }

    default public Stream<ONTObject<? extends E>> sorted() {
        return this.sorted(this.getObjectFactory());
    }

    default public Stream<ONTObject<? extends E>> members() {
        return this.members(this.getObjectFactory());
    }

    @Override
    default public Stream<ONTObject<? extends OWLObject>> objects() {
        return this.objects(this.getObjectFactory());
    }

    default public Set<E> getSetMinus(E ... excludes) {
        return this.sorted().map(ONTObject::getOWLObject).filter(WithManyObjects.negationPredicate(excludes)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @SafeVarargs
    public static <X> Predicate<X> negationPredicate(X ... excludes) {
        if (excludes.length == 0) {
            return x -> true;
        }
        HashSet set = new HashSet(Arrays.asList(excludes));
        return x -> !set.contains(x);
    }

    public static <R extends ONTObject & WithManyObjects> R create(OntStatement statement, BiFunction<Triple, Supplier<OntModel>, ? extends R> simple, BiFunction<Triple, Supplier<OntModel>, ? extends R> complex, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
        ONTObject c = (ONTObject)complex.apply(statement.asTriple(), factory.model());
        Object[] content = Complex.initContent((Complex)((Object)c), statement, setHash, true, factory, config);
        if (content != null) {
            ((WithContent)((Object)c)).putContent(content);
            return (R)c;
        }
        ONTObject s = (ONTObject)simple.apply(statement.asTriple(), factory.model());
        setHash.accept((OWLAxiom)s, c.hashCode());
        return (R)s;
    }

    public static <R extends ONTObject & Complex> R create(OntStatement statement, BiFunction<Triple, Supplier<OntModel>, ? extends R> maker, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
        ONTObject res = (ONTObject)maker.apply(statement.asTriple(), factory.model());
        ((WithContent)((Object)res)).putContent(Complex.initContent((Complex)((Object)res), statement, setHash, false, factory, config));
        return (R)res;
    }

    public static interface Complex<A extends OWLAxiom, E extends OWLObject>
    extends WithManyObjects<E>,
    WithList<A, E> {
        public static Object[] initContent(Complex axiom, OntStatement statement, ObjIntConsumer<OWLAxiom> setHash, boolean simplify, ModelObjectFactory factory, AxiomsSettings config) {
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            Set components = axiom.fetchONTComponents(statement, factory);
            Object[] res = new Object[components.size() + annotations.size()];
            int index = 0;
            int h = 1;
            for (ONTObject c : components) {
                res[index++] = axiom.toContentItem(c);
                h = WithContent.hashIteration(h, c.hashCode());
            }
            int hash = OWLObject.hashIteration((int)axiom.hashIndex(), (int)h);
            h = 1;
            for (ONTObject<OWLAnnotation> a : annotations) {
                res[index++] = a;
                h = WithContent.hashIteration(h, a.hashCode());
            }
            setHash.accept(axiom, OWLObject.hashIteration((int)hash, (int)h));
            if (simplify && annotations.isEmpty()) {
                if (res.length == 1 && res[0] instanceof String) {
                    return null;
                }
                if (res.length == 2 && res[0] instanceof String && res[1] instanceof String) {
                    return null;
                }
            }
            return res;
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            ModelObjectFactory factory = this.getObjectFactory();
            ArrayList<ONTObject<OWLAnnotation>> res = new ArrayList<ONTObject<OWLAnnotation>>(2);
            this.fetchONTComponents(statement, factory).forEach(c -> res.add((ONTObject<OWLAnnotation>)this.toContentItem((ONTObject)c)));
            res.addAll(ONTAxiomImpl.collectAnnotations(statement, factory, this.getConfig()));
            return res.toArray();
        }

        @Override
        default public ONTObject fromContentItem(Object x, ModelObjectFactory factory) {
            return x instanceof String ? this.findByURI((String)x, factory) : (ONTObject)x;
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects(ModelObjectFactory factory) {
            Stream<Object> res = Arrays.stream(this.getContent());
            return res.map(x -> this.fromContentItem(x, factory));
        }

        @Override
        default public Stream<ONTObject<? extends E>> members(ModelObjectFactory factory) {
            return this.sorted(factory);
        }

        @Override
        default public Stream<ONTObject<? extends E>> sorted(ModelObjectFactory factory) {
            Stream<ONTObject<? extends E>> res = Arrays.stream(this.getContent()).map(x -> this.fromContentItem(x, factory)).filter(x -> WithList.toOWLAnnotation(x) == null);
            return res;
        }

        @Override
        default public Set<? extends OWLObject> getOWLComponentsAsSet(ModelObjectFactory factory) {
            Set res = OWLObjectImpl.createSortedSet();
            Arrays.stream(this.getContent()).map(x -> this.fromContentItem(x, factory)).filter(x -> WithList.toOWLAnnotation(x) == null).forEach(x -> res.add(x.getOWLObject()));
            return res;
        }
    }

    public static interface Simple<E extends OWLObject>
    extends WithManyObjects<E>,
    WithoutAnnotations {
        @Override
        default public boolean isAnnotated() {
            return false;
        }

        @Override
        default public Stream<ONTObject<? extends E>> members(ModelObjectFactory factory) {
            return this.objects(this.getObjectFactory());
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects(ModelObjectFactory factory) {
            return Stream.of(this.findByURI(this.getSubjectURI(), factory), this.findByURI(this.getObjectURI(), factory));
        }

        @Override
        default public Stream<ONTObject<? extends E>> sorted(ModelObjectFactory factory) {
            Set res = ONTObjectImpl.createContentSet();
            res.add(this.findByURI(this.getSubjectURI(), factory));
            res.add(this.findByURI(this.getObjectURI(), factory));
            return res.stream();
        }

        @Override
        default public Set<? extends OWLObject> getOWLComponentsAsSet(ModelObjectFactory factory) {
            Set res = OWLObjectImpl.createSortedSet();
            res.add(this.findByURI(this.getSubjectURI(), factory).getOWLObject());
            res.add(this.findByURI(this.getObjectURI(), factory).getOWLObject());
            return res;
        }
    }
}

