/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

interface WithOneObject<S extends OWLObject>
extends WithTriple {
    public ONTObject<? extends S> findURISubject(ModelObjectFactory var1);

    public ONTObject<? extends S> fetchONTSubject(OntStatement var1, ModelObjectFactory var2);

    public ONTObject<? extends S> findONTValue(ModelObjectFactory var1);

    default public ONTObject<? extends S> getONTValue() {
        return this.findONTValue(this.getObjectFactory());
    }

    @Override
    default public Set<? extends OWLObject> getOWLComponentsAsSet(ModelObjectFactory factory) {
        Set res = OWLObjectImpl.createSortedSet();
        res.add(this.findONTValue(factory).getOWLObject());
        return res;
    }

    public static <R extends ONTObject & WithOneObject> R create(OntStatement statement, BiFunction<Triple, Supplier<OntModel>, ? extends R> simple, BiFunction<Triple, Supplier<OntModel>, ? extends R> complex, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
        ONTObject s = (ONTObject)simple.apply(statement.asTriple(), factory.model());
        Object[] content = Complex.initContent((WithOneObject)((Object)s), statement, setHash, factory, config);
        if (content == null) {
            return (R)s;
        }
        ONTObject c = (ONTObject)complex.apply(statement.asTriple(), factory.model());
        setHash.accept((OWLAxiom)c, s.hashCode());
        ((WithContent)((Object)c)).putContent(content);
        return (R)c;
    }

    public static interface Complex<A extends OWLAxiom, X extends OWLObject>
    extends WithOneObject<X>,
    WithContent<A> {
        public static Object[] initContent(WithOneObject axiom, OntStatement statement, ObjIntConsumer<OWLAxiom> setHash, ModelObjectFactory factory, AxiomsSettings config) {
            Object[] res;
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            ONTObject value = axiom.fetchONTSubject(statement, factory);
            int hash = OWLObject.hashIteration((int)axiom.hashIndex(), (int)value.hashCode());
            int index = 0;
            if (statement.getSubject().isURIResource()) {
                res = new Object[annotations.size()];
            } else {
                res = new Object[annotations.size() + 1];
                res[index++] = value;
            }
            int h = 1;
            for (ONTObject<OWLAnnotation> a : annotations) {
                res[index++] = a;
                h = WithContent.hashIteration(h, a.hashCode());
            }
            setHash.accept(axiom, OWLObject.hashIteration((int)hash, (int)h));
            return res.length == 0 ? null : res;
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            ModelObjectFactory factory = this.getObjectFactory();
            ArrayList<ONTObject<Object>> res = new ArrayList<ONTObject<Object>>(1);
            ONTObject value = this.fetchONTSubject(statement, factory);
            if (!statement.getSubject().isURIResource()) {
                res.add(value);
            }
            res.addAll(ONTAxiomImpl.collectAnnotations(statement, factory, this.getConfig()));
            return res.toArray();
        }

        @Override
        default public ONTObject<? extends X> findONTValue(ModelObjectFactory factory) {
            return this.hasURISubject() ? this.findURISubject(factory) : (ONTObject)this.getContent()[0];
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            Object[] content = this.getContent();
            Stream<Object> res = Arrays.stream(content);
            if (this.hasURISubject()) {
                ModelObjectFactory factory = this.getObjectFactory();
                res = Stream.concat(Stream.of(this.findURISubject(factory)), res);
            }
            return res;
        }

        @Override
        default public boolean isAnnotated() {
            return ONTAnnotationImpl.hasAnnotations(this.getContent());
        }

        @Override
        default public Stream<OWLAnnotation> annotations() {
            return ONTAnnotationImpl.contentAsStream(this.getContent(), this.hasURISubject() ? 0 : 1);
        }

        @Override
        default public List<OWLAnnotation> annotationsAsList() {
            return ONTAnnotationImpl.contentAsList(this.getContent(), this.hasURISubject() ? 0 : 1);
        }
    }

    public static interface Simple<X extends OWLObject>
    extends WithOneObject<X>,
    WithoutAnnotations {
        @Override
        default public ONTObject<? extends X> findONTValue(ModelObjectFactory factory) {
            return this.findURISubject(factory);
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.findURISubject(this.getObjectFactory()));
        }

        @Override
        default public boolean isAnnotated() {
            return false;
        }
    }
}

