/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.WithMerge;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class ONTAnnotationImpl
extends ONTStatementImpl
implements OWLAnnotation,
ModelObject<OWLAnnotation>,
WithMerge<ONTObject<OWLAnnotation>> {
    protected ONTAnnotationImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
        super(subject, predicate, object, m);
    }

    public static ONTAnnotationImpl create(OntStatement statement, ModelObjectFactory factory, Supplier<OntModel> model) {
        Collection<ONTObject<OWLAnnotation>> annotations = ONTAnnotationImpl.collectAnnotations(statement, factory);
        if (annotations.isEmpty()) {
            SimpleImpl res = new SimpleImpl(statement.asTriple(), model);
            res.hashCode = ONTAnnotationImpl.collectHashCode(res, factory, 1);
        }
        Object[] content = new Object[annotations.size()];
        WithAnnotationsImpl res = new WithAnnotationsImpl(statement.asTriple(), model);
        int hash = 1;
        int index = 0;
        for (ONTObject<OWLAnnotation> a : annotations) {
            content[index++] = a;
            hash = WithContent.hashIteration(hash, a.hashCode());
        }
        res.hashCode = ONTAnnotationImpl.collectHashCode(res, factory, hash);
        res.putContent(content);
        return res;
    }

    private static int collectHashCode(ONTAnnotationImpl res, ModelObjectFactory factory, int contentHashCode) {
        int hash = OWLObject.hashIteration((int)res.hashIndex(), (int)res.findONTAnnotationProperty(factory).hashCode());
        hash = OWLObject.hashIteration((int)hash, (int)res.findONTAnnotationValue(factory).hashCode());
        return OWLObject.hashIteration((int)hash, (int)contentHashCode);
    }

    protected static Collection<ONTObject<OWLAnnotation>> collectAnnotations(OntStatement root, ONTObjectFactory factory) {
        TreeMap res = new TreeMap();
        OntModels.listAnnotations(root).mapWith(factory::getAnnotation).forEachRemaining(x -> WithMerge.add(res, x));
        return res.values();
    }

    public static boolean isDeprecated(String predicate, Object value) {
        return OWL.deprecated.getURI().equals(predicate) && Models.TRUE.asNode().getLiteral().equals(value);
    }

    public static ONTObject<? extends OWLAnnotationSubject> findONTSubject(ONTStatementImpl statement, ModelObjectFactory factory) {
        if (statement.subject instanceof String) {
            return factory.getIRI((String)statement.subject);
        }
        if (statement.subject instanceof BlankNodeId) {
            return factory.getAnonymousIndividual((BlankNodeId)statement.subject);
        }
        throw new OntApiException.IllegalState("Wrong subject: " + statement.subject);
    }

    public static ONTObject<OWLAnnotationProperty> findONTPredicate(ONTStatementImpl statement, ModelObjectFactory factory) {
        return factory.getAnnotationProperty(statement.predicate);
    }

    public static ONTObject<? extends OWLAnnotationValue> findONTObject(ONTStatementImpl statement, ModelObjectFactory factory) {
        if (statement.object instanceof BlankNodeId) {
            return factory.getAnonymousIndividual((BlankNodeId)statement.object);
        }
        if (statement.object instanceof LiteralLabel) {
            return factory.getLiteral((LiteralLabel)statement.object);
        }
        if (statement.object instanceof String) {
            return factory.getIRI((String)statement.object);
        }
        throw new OntApiException.IllegalState("Wrong object: " + statement.object);
    }

    public static Stream<OWLAnnotation> contentAsStream(Object[] content) {
        Stream<Object> res = Arrays.stream(content);
        return res;
    }

    public static List<OWLAnnotation> contentAsList(Object[] content) {
        List<Object> res = Arrays.asList(content);
        return Collections.unmodifiableList(res);
    }

    public static Stream<OWLAnnotation> contentAsStream(Object[] content, int fromIndex) {
        if (!ONTAnnotationImpl.hasAnnotations(content)) {
            return Stream.empty();
        }
        Stream<Object> res = Arrays.stream(content, fromIndex, content.length);
        return res;
    }

    public static List<OWLAnnotation> contentAsList(Object[] content, int fromIndex) {
        if (!ONTAnnotationImpl.hasAnnotations(content)) {
            return Collections.emptyList();
        }
        List<Object> res = Arrays.asList(Arrays.copyOfRange(content, fromIndex, content.length));
        return Collections.unmodifiableList(res);
    }

    public static boolean hasAnnotations(Object[] content) {
        return content[content.length - 1] instanceof OWLAnnotation;
    }

    @Override
    public OWLAnnotation getOWLObject() {
        return this;
    }

    @Override
    public Stream<Triple> triples() {
        OntStatement root = this.asStatement();
        Stream<Triple> res = Stream.concat(Stream.of(root.asTriple()), this.objects().flatMap(ONTObject::triples));
        OntAnnotation a = root.getSubject().getAs(OntAnnotation.class);
        if (a != null) {
            res = Stream.concat(res, a.spec().map(FrontsTriple::asTriple));
        }
        return res;
    }

    @Override
    public Stream<ONTObject<? extends OWLObject>> objects() {
        return Stream.of(this.getONTAnnotationProperty(), this.getONTAnnotationValue());
    }

    public boolean isDeprecatedIRIAnnotation() {
        return ONTAnnotationImpl.isDeprecated(this.predicate, this.object);
    }

    public OWLAnnotationProperty getProperty() {
        return this.getONTAnnotationProperty().getOWLObject();
    }

    public OWLAnnotationValue getValue() {
        return this.getONTAnnotationValue().getOWLObject();
    }

    public OWLAnnotation getAnnotatedAnnotation(Stream<OWLAnnotation> annotations) {
        return this.createAnnotation(this.appendAnnotations(annotations.iterator()));
    }

    public OWLAnnotation getAnnotatedAnnotation(Collection<OWLAnnotation> annotations) {
        return this.createAnnotation(this.appendAnnotations(annotations.iterator()));
    }

    protected OWLAnnotation createAnnotation(Collection<OWLAnnotation> annotations) {
        return this.getDataFactory().getOWLAnnotation(ONTAnnotationImpl.eraseModel(this.getProperty()), ONTAnnotationImpl.eraseModel(this.getValue()), annotations);
    }

    public ONTObject<OWLAnnotationProperty> getONTAnnotationProperty() {
        return this.findONTAnnotationProperty(this.getObjectFactory());
    }

    public ONTObject<? extends OWLAnnotationValue> getONTAnnotationValue() {
        return this.findONTAnnotationValue(this.getObjectFactory());
    }

    protected ONTObject<OWLAnnotationProperty> findONTAnnotationProperty(ModelObjectFactory factory) {
        return ONTAnnotationImpl.findONTPredicate(this, factory);
    }

    protected ONTObject<? extends OWLAnnotationValue> findONTAnnotationValue(ModelObjectFactory factory) {
        return ONTAnnotationImpl.findONTObject(this, factory);
    }

    @Override
    public boolean canContainNamedClasses() {
        return false;
    }

    @Override
    public boolean canContainNamedIndividuals() {
        return false;
    }

    @Override
    public boolean canContainDataProperties() {
        return false;
    }

    @Override
    public boolean canContainObjectProperties() {
        return false;
    }

    @Override
    public boolean canContainClassExpressions() {
        return false;
    }

    @Override
    public ONTAnnotationImpl merge(ONTObject<OWLAnnotation> other) {
        if (this == other) {
            return this;
        }
        if (other instanceof ONTAnnotationImpl && this.sameTriple((ONTAnnotationImpl)other)) {
            return this;
        }
        ONTAnnotationImpl res = this.makeCopyWith(other);
        res.hashCode = this.hashCode;
        return res;
    }

    protected abstract ONTAnnotationImpl makeCopyWith(ONTObject<OWLAnnotation> var1);

    public static class WithAnnotationsImpl
    extends ONTAnnotationImpl
    implements WithContent<WithAnnotationsImpl> {
        protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

        public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
            this(WithAnnotationsImpl.strip(t.getSubject()), t.getPredicate().getURI(), WithAnnotationsImpl.strip(t.getObject()), m);
        }

        protected WithAnnotationsImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return other instanceof WithAnnotationsImpl && this.predicate.equals(other.predicate) && this.object.equals(other.object) && Arrays.equals(this.getContent(), ((WithAnnotationsImpl)other).getContent());
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            Stream<OWLAnnotation> res = Stream.concat(super.objects(), this.annotations());
            return res;
        }

        @Override
        public Object[] collectContent() {
            return WithAnnotationsImpl.collectAnnotations(this.asStatement(), this.getObjectFactory()).toArray();
        }

        @Override
        public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
            return this.content;
        }

        @Override
        public boolean isAnnotated() {
            return true;
        }

        @Override
        public Stream<OWLAnnotation> annotations() {
            return WithAnnotationsImpl.contentAsStream(this.getContent());
        }

        @Override
        public List<OWLAnnotation> annotationsAsList() {
            return WithAnnotationsImpl.contentAsList(this.getContent());
        }

        @Override
        public OWLAnnotation eraseModel() {
            return this.getDataFactory().getOWLAnnotation(WithAnnotationsImpl.eraseModel(this.getProperty()), WithAnnotationsImpl.eraseModel(this.getValue()), this.factoryAnnotations());
        }

        @Override
        protected WithAnnotationsImpl makeCopyWith(final ONTObject<OWLAnnotation> other) {
            WithAnnotationsImpl res = new WithAnnotationsImpl(this.subject, this.predicate, this.object, this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
            if (this.hasContent()) {
                res.putContent(this.getContent());
            }
            return res;
        }
    }

    public static class SimpleImpl
    extends ONTAnnotationImpl
    implements WithoutAnnotations {
        protected SimpleImpl(Triple t, Supplier<OntModel> m) {
            this(SimpleImpl.strip(t.getSubject()), t.getPredicate().getURI(), SimpleImpl.strip(t.getObject()), m);
        }

        protected SimpleImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return !other.isAnnotated() && this.predicate.equals(other.predicate) && this.object.equals(other.object);
        }

        @Override
        protected boolean sameAs(ONTStatementImpl other) {
            if (this.notSame(other)) {
                return false;
            }
            return this.sameContent(other);
        }

        @Override
        protected SimpleImpl makeCopyWith(final ONTObject<OWLAnnotation> other) {
            return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
        }

        @Override
        public boolean containsDatatype(OWLDatatype datatype) {
            return this.object instanceof LiteralLabel && this.getONTAnnotationValue().getOWLObject().containsEntityInSignature((OWLEntity)datatype);
        }

        @Override
        public boolean containsAnnotationProperty(OWLAnnotationProperty property) {
            return this.getONTAnnotationProperty().getOWLObject().equals(property);
        }

        @Override
        public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
            return this.object instanceof BlankNodeId ? SimpleImpl.createSet(this.retrieveAnonymousIndividual()) : SimpleImpl.createSet();
        }

        @Override
        public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
            return SimpleImpl.createSet(this.getProperty());
        }

        @Override
        public Set<OWLDatatype> getDatatypeSet() {
            return this.object instanceof LiteralLabel ? SimpleImpl.createSet(this.retrieveDatatype()) : SimpleImpl.createSet();
        }

        private OWLDatatype retrieveDatatype() {
            return ((OWLLiteral)this.getValue().asLiteral().orElseThrow(OntApiException.IllegalState::new)).getDatatype();
        }

        private OWLAnonymousIndividual retrieveAnonymousIndividual() {
            return (OWLAnonymousIndividual)this.getValue().asAnonymousIndividual().orElseThrow(OntApiException.IllegalState::new);
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            Set<OWLEntity> res = SimpleImpl.createSortedSet();
            res.add((OWLEntity)this.getProperty());
            if (this.object instanceof LiteralLabel) {
                res.add((OWLEntity)this.retrieveDatatype());
            }
            return res;
        }

        @Override
        public OWLAnnotation eraseModel() {
            return this.getDataFactory().getOWLAnnotation(SimpleImpl.eraseModel(this.getProperty()), SimpleImpl.eraseModel(this.getValue()));
        }
    }
}

