/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTResourceImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSimple;
import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntModel;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public abstract class ONTEntityImpl<X extends OWLEntity>
extends ONTResourceImpl
implements OWLEntity,
ModelObject<X>,
ONTSimple {
    protected ONTEntityImpl(String uri, Supplier<OntModel> m) {
        super(uri, m);
    }

    public static String getURI(OWLEntity e) {
        if (e instanceof ONTEntityImpl) {
            return ((ONTEntityImpl)e).getURI();
        }
        return e.getIRI().getIRIString();
    }

    @Override
    public X getOWLObject() {
        return (X)this;
    }

    @Override
    public X eraseModel() {
        return (X)this.getDataFactory().getOWLEntity(this.getEntityType(), this.getIRI());
    }

    @Override
    public String getURI() {
        return (String)this.node;
    }

    @Override
    public Node asNode() {
        return NodeFactory.createURI((String)this.getURI());
    }

    @Override
    public abstract OntEntity asRDFNode();

    public IRI getIRI() {
        return this.getObjectFactory().toIRI(this.getURI());
    }

    public String toStringID() {
        return this.getURI();
    }

    public boolean isBuiltIn() {
        try {
            return this.asRDFNode().isBuiltIn();
        }
        catch (OntJenaException.Conversion ex) {
            return false;
        }
    }

    @Override
    public Set<OWLEntity> getSignatureSet() {
        return ONTEntityImpl.createSet(this);
    }

    @Override
    public boolean containsEntity(OWLEntity entity) {
        return this.equals(entity);
    }

    @Override
    public Set<OWLClass> getNamedClassSet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLDatatype> getDatatypeSet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLNamedIndividual> getNamedIndividualSet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLDataProperty> getDataPropertySet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertySet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLClassExpression> getClassExpressionSet() {
        return ONTEntityImpl.createSet();
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
        return ONTEntityImpl.createSet();
    }

    protected boolean equals(Resource uri) {
        return this.node.equals(uri.getURI());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLEntity)) {
            return false;
        }
        OWLEntity entity = (OWLEntity)obj;
        if (this.typeIndex() != entity.typeIndex()) {
            return false;
        }
        if (entity instanceof ONTResourceImpl) {
            return this.sameAs((ONTResourceImpl)entity);
        }
        if (this.hashCode != 0 && entity.hashCode() != this.hashCode) {
            return false;
        }
        return this.getURI().equals(entity.getIRI().getIRIString());
    }

    @Override
    public int compareTo(@Nullable OWLObject other) {
        int res = Integer.compare(this.typeIndex(), Objects.requireNonNull(other, "Null object").typeIndex());
        return res != 0 ? res : (other instanceof HasIRI ? this.getIRI().compareTo((OWLObject)((HasIRI)other).getIRI()) : 0);
    }
}

