/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.objects.ONTComposite;
import com.github.owlcs.ontapi.internal.objects.ONTResourceImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public abstract class ONTExpressionImpl<R extends OntObject>
extends ONTResourceImpl
implements ONTComposite,
WithContent<ONTExpressionImpl<R>> {
    protected final InternalCache.Loading<ONTExpressionImpl<R>, Object[]> content = this.createContentCache();

    protected ONTExpressionImpl(BlankNodeId n, Supplier<OntModel> m) {
        super(n, m);
    }

    protected static Object toContentItem(OntObjectProperty ope, ONTObjectFactory factory) {
        if (ope.isURIResource()) {
            return ope.asNode().getURI();
        }
        return factory.getProperty(ope);
    }

    protected static Object toContentItem(OntClass ce, ONTObjectFactory factory) {
        if (ce.isURIResource()) {
            return ce.asNode().getURI();
        }
        return factory.getClass(ce);
    }

    protected static Object toContentItem(OntDataRange dr, ONTObjectFactory factory) {
        if (dr.isURIResource()) {
            return dr.asNode().getURI();
        }
        return factory.getDatatype(dr);
    }

    protected static Object toContentItem(OntIndividual i) {
        if (i.isURIResource()) {
            return i.asNode().getURI();
        }
        return i.asNode().getBlankNodeId();
    }

    protected static Object toContentItem(OntDataProperty ndp) {
        return ndp.asNode().getURI();
    }

    protected static Object toContentItem(Literal literal) {
        return literal.asNode().getLiteral();
    }

    protected abstract Object[] collectContent(R var1, ONTObjectFactory var2);

    protected abstract Object[] initContent(R var1, ONTObjectFactory var2);

    @Override
    protected BlankNodeId getBlankNodeId() {
        return (BlankNodeId)this.node;
    }

    @Override
    public Node asNode() {
        return NodeFactory.createBlankNode((BlankNodeId)this.getBlankNodeId());
    }

    public abstract R asRDFNode();

    @Override
    public Stream<Triple> triples() {
        return Stream.concat(super.triples(), this.objects().flatMap(ONTObject::triples));
    }

    @Override
    public final Object[] collectContent() {
        return this.collectContent(this.asRDFNode(), this.getObjectFactory());
    }

    @Override
    public InternalCache.Loading<ONTExpressionImpl<R>, Object[]> getContentCache() {
        return this.content;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLObject)) {
            return false;
        }
        OWLObject other = (OWLObject)obj;
        if (this.typeIndex() != other.typeIndex()) {
            return false;
        }
        if (other instanceof ONTExpressionImpl) {
            ONTExpressionImpl expr = (ONTExpressionImpl)other;
            if (this.notSame(expr)) {
                return false;
            }
            if (this.node.equals(expr.node)) {
                return true;
            }
            return Arrays.equals(this.getContent(), expr.getContent());
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return ONTExpressionImpl.equalIterators(this.components().iterator(), other.components().iterator());
    }

    protected ONTObject<? extends OWLIndividual> toIndividual(Object item, ModelObjectFactory factory) {
        if (item instanceof String) {
            return factory.getNamedIndividual((String)item);
        }
        return factory.getAnonymousIndividual((BlankNodeId)item);
    }

    protected ONTObject<? extends OWLObjectPropertyExpression> toOPE(Object item, ModelObjectFactory factory) {
        if (item instanceof String) {
            return factory.getObjectProperty((String)item);
        }
        return (ONTObject)item;
    }

    protected ONTObject<OWLDataProperty> toNDP(Object item, ModelObjectFactory factory) {
        if (item instanceof String) {
            return factory.getDataProperty((String)item);
        }
        return (ONTObject)item;
    }

    protected ONTObject<? extends OWLClassExpression> toCE(Object item, ModelObjectFactory factory) {
        if (item instanceof String) {
            return factory.getClass((String)item);
        }
        return (ONTObject)item;
    }

    protected ONTObject<? extends OWLDataRange> toDR(Object item, ModelObjectFactory factory) {
        if (item instanceof String) {
            return factory.getDatatype((String)item);
        }
        return (ONTObject)item;
    }

    protected ONTObject<OWLLiteral> toLiteral(Object item, ModelObjectFactory factory) {
        return factory.getLiteral((LiteralLabel)item);
    }
}

