/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTExpressionImpl;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class ONTFacetRestrictionImpl
extends ONTExpressionImpl<OntFacetRestriction>
implements OWLFacetRestriction,
ModelObject<OWLFacetRestriction> {
    public ONTFacetRestrictionImpl(BlankNodeId n, Supplier<OntModel> m) {
        super(n, m);
    }

    public static ONTFacetRestrictionImpl create(OntFacetRestriction fr, ONTObjectFactory factory, Supplier<OntModel> model) {
        ONTFacetRestrictionImpl res = new ONTFacetRestrictionImpl(fr.asNode().getBlankNodeId(), model);
        res.putContent(res.initContent(fr, factory));
        return res;
    }

    @Override
    public OntFacetRestriction asRDFNode() {
        return this.as(OntFacetRestriction.class);
    }

    @Override
    public OWLFacetRestriction getOWLObject() {
        return this;
    }

    @Override
    protected Object[] collectContent(OntFacetRestriction fr, ONTObjectFactory factory) {
        Class<OntFacetRestriction> type = OntModels.getOntType(fr);
        return new Object[]{ReadHelper.getFacet(type), fr.getValue().asNode().getLiteral()};
    }

    @Override
    protected Object[] initContent(OntFacetRestriction fr, ONTObjectFactory factory) {
        OWLFacet facet = ReadHelper.getFacet(OntModels.getOntType(fr));
        Literal value = fr.getValue();
        int hash = OWLObject.hashIteration((int)this.hashIndex(), (int)facet.hashCode());
        this.hashCode = OWLObject.hashIteration((int)hash, (int)factory.getLiteral(value).hashCode());
        return new Object[]{facet, value.asNode().getLiteral()};
    }

    public OWLFacet getFacet() {
        return (OWLFacet)this.getContent()[0];
    }

    public OWLLiteral getFacetValue() {
        return this.getONTLiteral().getOWLObject();
    }

    public ONTObject<OWLLiteral> getONTLiteral() {
        return this.findONTLiteral(this.getObjectFactory());
    }

    protected ONTObject<OWLLiteral> findONTLiteral(ModelObjectFactory factory) {
        return factory.getLiteral((LiteralLabel)this.getContent()[1]);
    }

    @Override
    public OWLFacetRestriction eraseModel() {
        return this.getDataFactory().getOWLFacetRestriction(this.getFacet(), ONTFacetRestrictionImpl.eraseModel(this.getFacetValue()));
    }

    public OWLDatatype getDatatype() {
        return this.getFacetValue().getDatatype();
    }

    @Override
    public Stream<ONTObject<? extends OWLObject>> objects() {
        return Stream.of(this.getONTLiteral());
    }

    @Override
    public boolean containsDatatype(OWLDatatype datatype) {
        return this.getDatatype().equals(datatype);
    }

    @Override
    public Set<OWLEntity> getSignatureSet() {
        return ONTFacetRestrictionImpl.createSet(this.getDatatype());
    }

    @Override
    public boolean canContainNamedClasses() {
        return false;
    }

    @Override
    public Set<OWLDatatype> getDatatypeSet() {
        return ONTFacetRestrictionImpl.createSet(this.getDatatype());
    }

    @Override
    public boolean canContainNamedIndividuals() {
        return false;
    }

    @Override
    public boolean canContainDataProperties() {
        return false;
    }

    @Override
    public boolean canContainObjectProperties() {
        return false;
    }

    @Override
    public boolean canContainAnnotationProperties() {
        return false;
    }

    @Override
    public boolean canContainClassExpressions() {
        return false;
    }

    @Override
    public boolean canContainAnonymousIndividuals() {
        return false;
    }
}

