/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.AsRDFNode;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTComposite;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

public class ONTLiteralImpl
extends OWLLiteralImpl
implements OWLLiteral,
HasObjectFactory,
ONTComposite,
ModelObject<OWLLiteral>,
AsRDFNode {
    protected final Supplier<OntModel> model;

    public ONTLiteralImpl(LiteralLabel n, Supplier<OntModel> m) {
        super(n);
        this.model = Objects.requireNonNull(m);
    }

    public Literal asRDFNode() {
        return this.getModel().asRDFNode(this.asNode()).asLiteral();
    }

    @Override
    public OWLLiteral getOWLObject() {
        return this;
    }

    @Override
    public OntModel getModel() {
        return this.model.get();
    }

    @Override
    public OWLLiteral eraseModel() {
        return this.getDataFactory().getOWLLiteral(this.label);
    }

    @Override
    @Nonnull
    public ModelObjectFactory getObjectFactory() {
        return HasObjectFactory.getObjectFactory(this.getModel());
    }

    public OntDataRange.Named getDatatypeResource() {
        return PersonalityModel.asPersonalityModel(this.getModel()).getNodeAs(NodeFactory.createURI((String)this.getDatatypeURI()), OntDataRange.Named.class);
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.getONTDatatype().getOWLObject();
    }

    public ONTObject<? extends OWLDatatype> getONTDatatype() {
        return this.getObjectFactory().getDatatype(this.getDatatypeURI());
    }

    @Override
    public Stream<Triple> triples() {
        OntDataRange.Named res = this.getDatatypeResource();
        return res.isBuiltIn() ? Stream.empty() : res.spec().map(FrontsTriple::asTriple);
    }

    @Override
    public Stream<ONTObject<? extends OWLObject>> objects() {
        return Stream.of(this.getONTDatatype());
    }

    @Override
    public boolean canContainClassExpressions() {
        return false;
    }

    @Override
    public boolean canContainAnonymousIndividuals() {
        return false;
    }

    @Override
    public boolean canContainNamedClasses() {
        return false;
    }

    @Override
    public boolean canContainNamedIndividuals() {
        return false;
    }

    @Override
    public boolean canContainObjectProperties() {
        return false;
    }

    @Override
    public boolean canContainDataProperties() {
        return false;
    }

    @Override
    public boolean canContainAnnotationProperties() {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("Suspicious method call. Serialization is unsupported for ONTLiteral.");
    }

    private void readObject(ObjectInputStream in) throws Exception {
        throw new NotSerializableException("Suspicious method call. Deserialization is unsupported for ONTLiteral.");
    }
}

