/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTCollectors;
import com.github.owlcs.ontapi.internal.objects.ONTComposite;
import com.github.owlcs.ontapi.internal.objects.ONTPrefixMappingRenderer;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public abstract class ONTObjectImpl
extends OWLObjectImpl
implements ONTComposite,
HasObjectFactory {
    protected final Supplier<OntModel> model;

    protected ONTObjectImpl(Supplier<OntModel> model) {
        this.model = Objects.requireNonNull(model, "Null model.");
    }

    public static <X extends ONTObject<? extends OWLObject>> Set<X> createContentSet() {
        return ONTObjectImpl.createSortedSet(Comparator.comparing(ONTObject::getOWLObject));
    }

    public static <X extends OWLObject> X eraseModel(X object) {
        if (object instanceof ModelObject) {
            return ((ModelObject)object).eraseModel();
        }
        if (object instanceof ONTObject) {
            return (X)((ONTObject)object).getOWLObject();
        }
        return object;
    }

    public OntModel getModel() {
        return this.model.get();
    }

    @Override
    @Nonnull
    public ModelObjectFactory getObjectFactory() {
        return HasObjectFactory.getObjectFactory(this.getModel());
    }

    protected PersonalityModel getPersonalityModel() {
        return PersonalityModel.asPersonalityModel(this.getModel());
    }

    @Override
    public final boolean containsEntityInSignature(@Nullable OWLEntity entity) {
        return entity != null && this.containsEntity(entity);
    }

    public boolean containsEntity(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.containsNamedClass(entity.asOWLClass());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.containsNamedIndividual(entity.asOWLNamedIndividual());
        }
        if (entity.isOWLDatatype()) {
            return this.containsDatatype(entity.asOWLDatatype());
        }
        if (entity.isOWLObjectProperty()) {
            return this.containsObjectProperty(entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.containsDataProperty(entity.asOWLDataProperty());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.containsAnnotationProperty(entity.asOWLAnnotationProperty());
        }
        return false;
    }

    public boolean containsNamedClass(OWLClass clazz) {
        return this.canContainClassExpressions() ? (Boolean)this.accept(ONTCollectors.forClass(clazz)) : false;
    }

    public boolean containsNamedIndividual(OWLNamedIndividual individual) {
        return this.canContainNamedIndividuals() ? (Boolean)this.accept(ONTCollectors.forNamedIndividual(individual)) : false;
    }

    public boolean containsDatatype(OWLDatatype datatype) {
        return this.canContainDatatypes() ? (Boolean)this.accept(ONTCollectors.forDatatype(datatype)) : false;
    }

    public boolean containsObjectProperty(OWLObjectProperty property) {
        return this.canContainObjectProperties() ? (Boolean)this.accept(ONTCollectors.forObjectProperty(property)) : false;
    }

    public boolean containsDataProperty(OWLDataProperty property) {
        return this.canContainDataProperties() ? (Boolean)this.accept(ONTCollectors.forDataProperty(property)) : false;
    }

    public boolean containsAnnotationProperty(OWLAnnotationProperty property) {
        return this.canContainAnnotationProperties() ? (Boolean)this.accept(ONTCollectors.forAnnotationProperty(property)) : false;
    }

    @Override
    public Set<OWLEntity> getSignatureSet() {
        return (Set)this.accept(ONTCollectors.forEntities(ONTObjectImpl.createSortedSet()));
    }

    @Override
    public Set<OWLClassExpression> getClassExpressionSet() {
        return this.canContainClassExpressions() ? (Set)this.accept(ONTCollectors.forClassExpressions(new HashSet<OWLClassExpression>())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
        return this.canContainAnonymousIndividuals() ? (Set)this.accept(ONTCollectors.forAnonymousIndividuals(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLClass> getNamedClassSet() {
        return this.canContainNamedClasses() ? (Set)this.accept(ONTCollectors.forClasses(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLNamedIndividual> getNamedIndividualSet() {
        return this.canContainNamedIndividuals() ? (Set)this.accept(ONTCollectors.forNamedIndividuals(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLDatatype> getDatatypeSet() {
        return this.canContainDatatypes() ? (Set)this.accept(ONTCollectors.forDatatypes(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertySet() {
        return this.canContainObjectProperties() ? (Set)this.accept(ONTCollectors.forObjectProperties(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLDataProperty> getDataPropertySet() {
        return this.canContainDataProperties() ? (Set)this.accept(ONTCollectors.forDataProperties(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
        return this.canContainAnnotationProperties() ? (Set)this.accept(ONTCollectors.forAnnotationProperties(ONTObjectImpl.createSortedSet())) : ONTObjectImpl.createSet();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("Suspicious method call. Serialization is unsupported for " + this.getClass().getSimpleName() + ".");
    }

    private void readObject(ObjectInputStream in) throws Exception {
        throw new NotSerializableException("Suspicious method call. Deserialization is unsupported for " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public String toString() {
        return new ONTPrefixMappingRenderer(this.getModel()).render(this);
    }
}

