/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.PrefixMappingRenderer;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTLiteralImpl;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.util.EscapeUtils;

@ParametersAreNonnullByDefault
class ONTPrefixMappingRenderer
extends PrefixMappingRenderer {
    public ONTPrefixMappingRenderer(PrefixMapping pm) {
        super(pm);
    }

    @Override
    protected String shortForm(OWLEntity entity) {
        return this.shortForm(((ONTEntityImpl)entity).getURI());
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.sb.append(((OWLAnonymousIndividualImpl)individual).getBlankNodeId().getLabelString());
    }

    @Override
    public void visit(OWLLiteral literal) {
        this.visit((ONTLiteralImpl)literal);
    }

    public void visit(OWLLiteralImpl node) {
        String txt = EscapeUtils.escapeString((String)node.getLiteral());
        this.sb.append('\"').append(txt).append('\"');
        String dt = node.getDatatypeURI();
        if (RDF.PlainLiteral.getURI().equals(dt) || RDF.langString.getURI().equals(dt)) {
            if (node.hasLang()) {
                this.sb.append('@').append(node.getLang());
            }
        } else if (!XSD.xstring.getURI().equals(dt)) {
            this.sb.append("^^");
            node.getDatatype().accept((OWLObjectVisitor)this);
        }
    }
}

