/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTResourceImpl;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;

public class ONTSWRLIndividualImpl
extends ONTResourceImpl
implements SWRLIndividualArgument,
ModelObject<SWRLIndividualArgument> {
    public ONTSWRLIndividualImpl(String uri, Supplier<OntModel> m) {
        super(uri, m);
    }

    public ONTSWRLIndividualImpl(BlankNodeId id, Supplier<OntModel> m) {
        super(id, m);
    }

    public static ONTSWRLIndividualImpl create(OntIndividual i, Supplier<OntModel> m) {
        return ONTSWRLIndividualImpl.create(i.asNode(), m);
    }

    protected static ONTSWRLIndividualImpl create(Node i, Supplier<OntModel> m) {
        if (i.isURI()) {
            return new ONTSWRLIndividualImpl(i.getURI(), m);
        }
        return new ONTSWRLIndividualImpl(i.getBlankNodeId(), m);
    }

    @Override
    public SWRLIndividualArgument getOWLObject() {
        return this;
    }

    @Override
    protected BlankNodeId getBlankNodeId() {
        return this.node instanceof BlankNodeId ? (BlankNodeId)this.node : (BlankNodeId)this.wrongState();
    }

    @Override
    protected String getURI() {
        return this.node instanceof String ? (String)this.node : (String)this.wrongState();
    }

    @Override
    public Node asNode() {
        if (this.node instanceof String) {
            return NodeFactory.createURI((String)((String)this.node));
        }
        if (this.node instanceof BlankNodeId) {
            return NodeFactory.createBlankNode((BlankNodeId)((BlankNodeId)this.node));
        }
        return (Node)this.wrongState();
    }

    private <X> X wrongState() {
        throw new OntApiException.IllegalState("Must be URI or b-node: " + this.node);
    }

    @Override
    public OntSWRL.IArg asRDFNode() {
        return this.as(OntSWRL.IArg.class);
    }

    public OntIndividual asIndividual() {
        return this.as(OntIndividual.class);
    }

    public OWLIndividual getIndividual() {
        return this.getONTIndividual().getOWLObject();
    }

    public ONTObject<? extends OWLIndividual> getONTIndividual() {
        ModelObjectFactory factory = this.getObjectFactory();
        if (this.node instanceof String) {
            return factory.getNamedIndividual((String)this.node);
        }
        if (this.node instanceof BlankNodeId) {
            return factory.getAnonymousIndividual((BlankNodeId)this.node);
        }
        return (ONTObject)this.wrongState();
    }

    @Override
    public SWRLIndividualArgument eraseModel() {
        return this.getDataFactory().getSWRLIndividualArgument(ONTSWRLIndividualImpl.eraseModel(this.getIndividual()));
    }

    @Override
    public boolean containsNamedIndividual(OWLNamedIndividual individual) {
        OWLIndividual i = this.getIndividual();
        return i.isOWLNamedIndividual() && i.equals(individual);
    }

    @Override
    public Set<OWLEntity> getSignatureSet() {
        OWLIndividual i = this.getIndividual();
        return i.isNamed() ? ONTSWRLIndividualImpl.createSet(i.asOWLNamedIndividual()) : ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLNamedIndividual> getNamedIndividualSet() {
        OWLIndividual i = this.getIndividual();
        return i.isNamed() ? ONTSWRLIndividualImpl.createSet(i.asOWLNamedIndividual()) : ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
        OWLIndividual i = this.getIndividual();
        return i.isNamed() ? ONTSWRLIndividualImpl.createSet() : ONTSWRLIndividualImpl.createSet(i.asOWLAnonymousIndividual());
    }

    @Override
    public Set<OWLDatatype> getDatatypeSet() {
        return ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLClass> getNamedClassSet() {
        return ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLDataProperty> getDataPropertySet() {
        return ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertySet() {
        return ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
        return ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Set<OWLClassExpression> getClassExpressionSet() {
        return ONTSWRLIndividualImpl.createSet();
    }

    @Override
    public Stream<ONTObject<? extends OWLObject>> objects() {
        return Stream.of(this.getONTIndividual());
    }

    @Override
    public boolean canContainClassExpressions() {
        return false;
    }

    @Override
    public boolean canContainNamedClasses() {
        return false;
    }

    @Override
    public boolean canContainDatatypes() {
        return false;
    }

    @Override
    public boolean canContainObjectProperties() {
        return false;
    }

    @Override
    public boolean canContainDataProperties() {
        return false;
    }

    @Override
    public boolean canContainAnnotationProperties() {
        return false;
    }
}

