/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.objects.AsStatement;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithAnnotations;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.RDFNode;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class ONTStatementImpl
extends ONTObjectImpl
implements WithAnnotations,
AsStatement,
OWLObject {
    protected final Object subject;
    protected final String predicate;
    protected final Object object;

    protected ONTStatementImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
        super(m);
        this.subject = Objects.requireNonNull(subject);
        this.predicate = Objects.requireNonNull(predicate);
        this.object = Objects.requireNonNull(object);
    }

    public static Object fromNode(RDFNode r) {
        return ONTStatementImpl.strip(r.asNode());
    }

    public static Object strip(Node node) {
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank()) {
            return node.getBlankNodeId();
        }
        if (node.isLiteral()) {
            return node.getLiteral();
        }
        throw new OntApiException.IllegalState("Wrong node: " + node);
    }

    @Override
    public Triple asTriple() {
        return Triple.create((Node)this.getSubjectNode(), (Node)this.getPredicateNode(), (Node)this.getObjectNode());
    }

    @Override
    public OntStatement asStatement() {
        OntModel m = this.getModel();
        Triple t = this.asTriple();
        return m.asStatement((Triple)Iter.findFirst(m.getGraph().find(t)).orElseThrow(() -> new OntApiException.IllegalState("Can't find triple " + t)));
    }

    public Stream<Triple> triples() {
        return Stream.of(this.asTriple());
    }

    protected Node getSubjectNode() {
        if (this.subject instanceof String) {
            return NodeFactory.createURI((String)((String)this.subject));
        }
        if (this.subject instanceof BlankNodeId) {
            return NodeFactory.createBlankNode((BlankNodeId)((BlankNodeId)this.subject));
        }
        throw new OntApiException.IllegalState();
    }

    protected Node getObjectNode() {
        if (this.object instanceof String) {
            return NodeFactory.createURI((String)((String)this.object));
        }
        if (this.object instanceof BlankNodeId) {
            return NodeFactory.createBlankNode((BlankNodeId)((BlankNodeId)this.object));
        }
        if (this.object instanceof LiteralLabel) {
            return NodeFactory.createLiteral((LiteralLabel)((LiteralLabel)this.object));
        }
        throw new OntApiException.IllegalState();
    }

    protected Node getPredicateNode() {
        return NodeFactory.createURI((String)this.predicate);
    }

    protected Collection<OWLAnnotation> appendAnnotations(Iterator<OWLAnnotation> other) {
        Set<OWLAnnotation> res = ONTStatementImpl.createSortedSet();
        other.forEachRemaining(x -> res.add(ONTStatementImpl.eraseModel(x)));
        this.factoryAnnotations().forEach(res::add);
        return res;
    }

    protected Stream<OWLAnnotation> factoryAnnotations() {
        return this.annotations().map(ONTObjectImpl::eraseModel);
    }

    public final boolean sameTriple(ONTStatementImpl other) {
        return this.sameSubject(other) && this.samePredicate(other) && this.sameObject(other);
    }

    protected final boolean sameSubject(ONTStatementImpl other) {
        return this.subject.equals(other.subject);
    }

    protected final boolean samePredicate(ONTStatementImpl other) {
        return this.predicate.equals(other.predicate);
    }

    protected final boolean sameObject(ONTStatementImpl other) {
        return this.object.equals(other.object);
    }

    protected abstract boolean sameContent(ONTStatementImpl var1);

    protected boolean sameComponents(HasComponents other) {
        return ONTStatementImpl.equalStreams(this.components(), other.components());
    }

    protected boolean sameAs(ONTStatementImpl other) {
        if (this.notSame(other)) {
            return false;
        }
        if (this.sameTriple(other)) {
            return true;
        }
        return this.sameContent(other);
    }

    @Override
    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLObject)) {
            return false;
        }
        OWLObject other = (OWLObject)obj;
        if (this.typeIndex() != other.typeIndex()) {
            return false;
        }
        if (other instanceof ONTStatementImpl) {
            return this.sameAs((ONTStatementImpl)other);
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.sameComponents((HasComponents)other);
    }
}

