/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers;

import com.github.owlcs.ontapi.internal.searchers.ForTopEntity;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public interface ForDatatype
extends ForTopEntity {
    public static final Set<Class<? extends OntClass.CardinalityRestrictionCE<?, ?>>> DATA_CARDINALITY_TYPES = Stream.of(OntClass.DataMaxCardinality.class, OntClass.DataMinCardinality.class, OntClass.DataCardinality.class).collect(Iter.toUnmodifiableSet());

    public static Class<? extends OntClass.RestrictionCE<?>> getSpecialDataRestrictionType(String uri) {
        Class res = null;
        if (XSD.xboolean.getURI().equals(uri)) {
            res = OntClass.HasSelf.class;
        }
        if (XSD.nonNegativeInteger.getURI().equals(uri)) {
            res = OntClass.CardinalityRestrictionCE.class;
        }
        return res;
    }

    @Override
    default public Resource getTopEntity() {
        return RDFS.Literal;
    }

    @Override
    default public boolean isCardinalityRestriction(OntStatement s) {
        return DATA_CARDINALITY_TYPES.stream().anyMatch(t -> s.getSubject().canAs((Class)t));
    }
}

