/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers;

import com.github.owlcs.ontapi.internal.BaseSearcher;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;

public class WithRootStatement
extends BaseSearcher {
    protected final ExtendedIterator<OntStatement> listRootStatements(OntModel model, OntStatement statement) {
        if (statement.getSubject().isURIResource()) {
            return Iter.of(statement);
        }
        return Iter.create(this.getRootStatements(model, statement));
    }

    protected Set<OntStatement> getRootStatements(OntModel model, OntStatement statement) {
        HashSet<OntStatement> roots = new HashSet<OntStatement>();
        HashSet seen = new HashSet();
        LinkedHashSet<OntStatement> candidates = new LinkedHashSet<OntStatement>();
        candidates.add(statement);
        while (!candidates.isEmpty()) {
            OntStatement st = (OntStatement)candidates.iterator().next();
            candidates.remove(st);
            OntObject subject = st.getSubject();
            if (subject.isURIResource() || subject.canAs(OntIndividual.Anonymous.class)) {
                roots.add(st);
                continue;
            }
            int count = candidates.size();
            this.listByObject(model, (RDFNode)subject).filterKeep(s -> s.getSubject().isURIResource() || seen.add(s.getSubject())).forEachRemaining(candidates::add);
            if (count != candidates.size()) continue;
            this.listProperties(model, subject).forEachRemaining(roots::add);
        }
        return roots;
    }

    protected ExtendedIterator<OntStatement> listProperties(OntModel model, OntObject root) {
        return this.listBySubject(model, root);
    }
}

