/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.ByObjectSearcher;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.objects.ONTExpressionImpl;
import com.github.owlcs.ontapi.internal.searchers.WithRootStatement;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

abstract class BaseByObject<A extends OWLAxiom, O extends OWLObject>
extends WithRootStatement
implements ByObjectSearcher<A, O> {
    BaseByObject() {
    }

    static Resource getRDFType(OWLEntity entity) {
        return WriteHelper.getRDFType(entity);
    }

    static Class<? extends OntEntity> getClassType(OWLEntity entity) {
        return WriteHelper.getEntityType(entity);
    }

    static Resource asResource(OWLEntity entity) {
        return WriteHelper.toResource(entity.getIRI());
    }

    static Resource asResource(OWLIndividual individual) {
        return WriteHelper.toResource(individual);
    }

    static Resource asResource(OWLAnnotationSubject subject) {
        return WriteHelper.toResource((OWLObject)subject);
    }

    static Resource asResource(OWLClass clazz) {
        return BaseByObject.asResource((OWLEntity)clazz);
    }

    static Resource asResource(OWLClassExpression clazz) {
        if (clazz.isOWLClass()) {
            return BaseByObject.asResource(clazz.asOWLClass());
        }
        if (clazz instanceof ONTExpressionImpl) {
            return new ResourceImpl(((ONTExpressionImpl)clazz).asNode(), null);
        }
        throw new OntApiException.Unsupported("Unsupported class-expression " + clazz);
    }

    static Resource asResource(OWLObjectPropertyExpression property) {
        if (property.isOWLObjectProperty()) {
            return BaseByObject.asResource((OWLEntity)property.asOWLObjectProperty());
        }
        if (property instanceof ONTExpressionImpl) {
            return new ResourceImpl(((ONTExpressionImpl)property).asNode(), null);
        }
        throw new OntApiException.Unsupported("Unsupported object-expression " + property);
    }

    public static boolean isSupported(OWLClassExpression clazz) {
        return clazz.isOWLClass() || clazz instanceof ONTExpressionImpl;
    }

    public static boolean isSupported(OWLObjectPropertyExpression property) {
        return property.isOWLObjectProperty() || property instanceof ONTExpressionImpl;
    }
}

