/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.internal.searchers.axioms.ByProperty;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;

public class ByAnnotationProperty
extends ByProperty<OWLAnnotationProperty> {
    @Override
    protected ExtendedIterator<OntStatement> listAssertions(OntModel m, String uri) {
        ExtendedIterator res = super.listAssertions(m, uri);
        if (ByAnnotationProperty.includeAnnotations(m)) {
            res = res.mapWith(this::toRootStatement);
        }
        return res;
    }

    protected OntStatement toRootStatement(OntStatement statement) {
        OntAnnotation a;
        OntObject subject = statement.getSubject();
        if (!subject.isAnon() || (a = subject.getAs(OntAnnotation.class)) == null) {
            return statement;
        }
        OntStatement base = ByAnnotationProperty.getRoot(a).getBase();
        if (base != null) {
            statement = base;
        }
        return statement;
    }
}

