/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.internal.searchers.ForDatatype;
import com.github.owlcs.ontapi.internal.searchers.axioms.WithCardinality;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLDatatype;

public class ByDatatype
extends WithCardinality<OWLDatatype>
implements ForDatatype {
    @Override
    protected ExtendedIterator<OntStatement> listExplicitStatements(OntModel m, String uri) {
        return this.excludeImplicit(Iter.flatMap(this.listStatements(m).filterKeep(s -> this.filter((OntStatement)s, uri)), s -> this.listRootStatements(m, (OntStatement)s)), uri);
    }

    protected ExtendedIterator<OntStatement> excludeImplicit(ExtendedIterator<OntStatement> res, String uri) {
        Class<? extends OntClass.RestrictionCE<?>> type = ForDatatype.getSpecialDataRestrictionType(uri);
        return type != null ? res.filterDrop(s -> s.getSubject().canAs(type)) : res;
    }

    @Override
    protected boolean filter(OntStatement s, String uri) {
        if (uri.equals(s.getSubject().getURI())) {
            return true;
        }
        return Models.containsURI(s.getObject(), uri);
    }

    @Override
    protected ExtendedIterator<OntStatement> listProperties(OntModel model, OntObject root) {
        return this.listPropertiesIncludeAnnotations(model, root);
    }
}

