/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByPrimitive;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public abstract class ByEntity<E extends OWLEntity>
extends ByPrimitive<E> {
    @Override
    public final ExtendedIterator<ONTObject<OWLAxiom>> listONTAxioms(E entity, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        ExtendedIterator<OntStatement> res = this.listStatements(model, entity);
        if (config.isSplitAxiomAnnotations()) {
            return Iter.flatMap(res, s -> Iter.flatMap(this.listTranslators((OntStatement)s, config), t -> ByEntity.split(t, s, factory, config)).filterKeep(x -> this.filter((OWLAxiom)x.getOWLObject(), entity)));
        }
        return Iter.flatMap(res, s -> this.listTranslators((OntStatement)s, config).mapWith(t -> ByEntity.toAxiom(t, s, factory, config)).filterKeep(x -> this.filter((OWLAxiom)x.getOWLObject(), entity)));
    }

    @Override
    public final ExtendedIterator<OntStatement> listStatements(OntModel model, E entity) {
        return this.listStatements(model, entity.getIRI().getIRIString());
    }

    protected <A extends OWLAxiom> boolean filter(A axiom, E entity) {
        return axiom.containsEntityInSignature(entity);
    }

    @Override
    protected ExtendedIterator<OntStatement> listStatements(OntModel m, String uri) {
        return super.listStatements(m, m.getResource(uri));
    }
}

