/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.OwlObjects;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByClass;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByDatatype;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByPrimitive;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;

public class ByIRI
extends ByPrimitive<IRI> {
    private static final ByClass BY_CLASS = new ByClass();
    private static final ByDatatype BY_DATATYPE = new ByDatatype();

    @Override
    public final ExtendedIterator<ONTObject<OWLAxiom>> listONTAxioms(IRI iri, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        ExtendedIterator<ONTObject<OWLAxiom>> res = super.listONTAxioms(iri, model, factory, config);
        if (ByIRI.isSystem(model, iri.getIRIString())) {
            return res.filterKeep(x -> this.containsURI(factory.getOWLDataFactory(), (OWLAxiom)x.getOWLObject(), iri));
        }
        return res;
    }

    @Override
    protected ExtendedIterator<OntStatement> listStatements(OntModel model, IRI iri) {
        String uri = iri.getIRIString();
        ExtendedIterator<OntStatement> res = this.listCandidates(model, uri);
        return BY_DATATYPE.includeImplicit(BY_CLASS.includeImplicit(res, model, uri), model, uri);
    }

    protected ExtendedIterator<OntStatement> listCandidates(OntModel model, String iri) {
        return Iter.flatMap(this.listStatements(model).filterKeep(x -> Models.containsURI(x, iri)), s -> this.listRootStatements(model, (OntStatement)s));
    }

    protected boolean containsURI(OWLDataFactory factory, OWLAxiom axiom, IRI iri) {
        block3: {
            block2: {
                if (axiom.isAnnotated()) break block2;
                if (!AxiomType.ANNOTATION_ASSERTION.equals((Object)axiom.getAxiomType())) break block3;
            }
            return OwlObjects.iris(axiom).anyMatch(arg_0 -> ((IRI)iri).equals(arg_0));
        }
        return EntityType.values().stream().map(t -> factory.getOWLEntity(t, iri)).anyMatch(arg_0 -> ((OWLAxiom)axiom).containsEntityInSignature(arg_0));
    }

    @Override
    protected ExtendedIterator<OntStatement> listProperties(OntModel model, OntObject root) {
        return this.listPropertiesIncludeAnnotations(model, root);
    }
}

