/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.internal.searchers.axioms.ByPrimitive;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLLiteral;

public class ByLiteral
extends ByPrimitive<OWLLiteral> {
    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, OWLLiteral literal) {
        Literal object = model.asRDFNode(OWLLiteralImpl.asONT(literal).asNode()).asLiteral();
        ExtendedIterator res = this.listByObject(model, (RDFNode)object);
        if (XSD.nonNegativeInteger.getURI().equals(object.getDatatypeURI())) {
            res = res.filterDrop(s -> s.getSubject().canAs(OntClass.CardinalityRestrictionCE.class));
        } else if (Models.TRUE.equals((Object)object)) {
            res = res.filterDrop(s -> s.getSubject().canAs(OntClass.HasSelf.class));
        }
        return Iter.flatMap(res, s -> this.listRootStatements(model, (OntStatement)s));
    }

    @Override
    protected ExtendedIterator<OntStatement> listProperties(OntModel model, OntObject root) {
        return this.listPropertiesIncludeAnnotations(model, root);
    }
}

