/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.SearchModel;
import com.github.owlcs.ontapi.internal.searchers.axioms.BaseByObject;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLPrimitive;

public abstract class ByPrimitive<P extends OWLPrimitive>
extends BaseByObject<OWLAxiom, P> {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = ByPrimitive.selectTranslators(null);

    protected static boolean includeAnnotations(OntModel m) {
        return !(m instanceof SearchModel) || ((SearchModel)m).hasAnnotations();
    }

    public static OntAnnotation getRoot(OntAnnotation annotation) {
        OntAnnotation parent = annotation.parent().orElse(null);
        return parent == null ? annotation : ByPrimitive.getRoot(parent);
    }

    protected static boolean isSystem(OntModel model, String uri) {
        if (model instanceof SearchModel) {
            return ((SearchModel)model).getSystemURIs().contains(uri);
        }
        OntPersonality.Reserved voc = PersonalityModel.asPersonalityModel(model).getOntPersonality().getReserved();
        Node node = NodeFactory.createURI((String)uri);
        return voc.getProperties().contains(node) || voc.getResources().contains(node);
    }

    final ExtendedIterator<OntStatement> listStatements(OntModel model, Resource resource) {
        return Iter.concat(this.listBySubject(model, resource), Iter.flatMap(this.listByObject(model, (RDFNode)resource), s -> this.listRootStatements(model, (OntStatement)s)));
    }

    protected abstract ExtendedIterator<OntStatement> listStatements(OntModel var1, P var2);

    @Override
    public ExtendedIterator<ONTObject<OWLAxiom>> listONTAxioms(P primitive, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        ExtendedIterator<OntStatement> res = this.listStatements(model, primitive);
        if (config.isSplitAxiomAnnotations()) {
            return Iter.flatMap(res, s -> Iter.flatMap(this.listTranslators((OntStatement)s, config), t -> ByPrimitive.split(t, s, factory, config)));
        }
        return Iter.flatMap(res, s -> this.listTranslators((OntStatement)s, config).mapWith(t -> ByPrimitive.toAxiom(t, s, factory, config)));
    }

    protected ExtendedIterator<AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators(OntStatement statement, AxiomsSettings conf) {
        return this.listTranslators().filterKeep(t -> t.testStatement(statement, conf));
    }

    protected ExtendedIterator<OntStatement> listPropertiesIncludeAnnotations(OntModel model, OntObject root) {
        if (!ByPrimitive.includeAnnotations(model)) {
            return this.listBySubject(model, root);
        }
        OntAnnotation a = root.getAs(OntAnnotation.class);
        if (a == null) {
            return this.listBySubject(model, root);
        }
        OntStatement base = ByPrimitive.getRoot(a).getBase();
        if (base != null) {
            return Iter.of(base);
        }
        return this.listBySubject(model, root);
    }
}

