/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLTopObjectType;
import com.github.owlcs.ontapi.internal.axioms.DeclarationTranslator;
import com.github.owlcs.ontapi.internal.searchers.axioms.BaseByObject;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class DeclarationByEntity
extends BaseByObject<OWLDeclarationAxiom, OWLEntity> {
    private static final DeclarationTranslator TRANSLATOR = (DeclarationTranslator)DeclarationByEntity.getTranslator(OWLTopObjectType.DECLARATION);

    @Override
    public ExtendedIterator<ONTObject<OWLDeclarationAxiom>> listONTAxioms(OWLEntity entity, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        Resource subject = DeclarationByEntity.asResource(entity);
        if (!model.independent()) {
            return this.listStatements(model, subject, RDF.type, (RDFNode)DeclarationByEntity.getRDFType(entity)).mapWith(x -> DeclarationByEntity.toAxiom(TRANSLATOR, x, factory, config));
        }
        OntEntity res = PersonalityModel.asPersonalityModel(model).findNodeAs(subject.asNode(), DeclarationByEntity.getClassType(entity));
        if (res == null) {
            return Iter.of();
        }
        OntStatement statement = res.getMainStatement();
        return statement == null ? Iter.of() : Iter.of(DeclarationByEntity.toAxiom(TRANSLATOR, statement, factory, config));
    }
}

