/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLTopObjectType;
import com.github.owlcs.ontapi.internal.axioms.DisjointClassesTranslator;
import com.github.owlcs.ontapi.internal.searchers.axioms.BaseByObject;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;

public class DisjointClassesByOperand
extends BaseByObject<OWLDisjointClassesAxiom, OWLClass> {
    public static final DisjointClassesTranslator TRANSLATOR = (DisjointClassesTranslator)DisjointClassesByOperand.getTranslator(OWLTopObjectType.DISJOINT_CLASSES);

    protected ExtendedIterator<OntStatement> listStatements(OntModel model, OntClass clazz) {
        ExtendedIterator simple = this.listBySubjectAndPredicate(model, clazz, OWL.disjointWith).andThen(this.listByPredicateAndObject(model, OWL.disjointWith, (RDFNode)clazz));
        ExtendedIterator bulk = OntModels.listLocalObjects(model, OntDisjoint.Classes.class).filterKeep(x -> x.getList().contains(clazz)).mapWith(OntObject::getMainStatement);
        return Iter.concat(simple, bulk);
    }

    @Override
    public ExtendedIterator<ONTObject<OWLDisjointClassesAxiom>> listONTAxioms(OWLClass clazz, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        ExtendedIterator res = this.listStatements(model, model.getOntClass(clazz.getIRI().getIRIString())).filterKeep(s -> TRANSLATOR.testStatement((OntStatement)s, config));
        return DisjointClassesByOperand.translate(TRANSLATOR, (ExtendedIterator<OntStatement>)res, factory, config);
    }
}

