/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.searchers.objects.PropertySearcher;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;

public class AnnotationPropertySearcher
extends PropertySearcher<OWLAnnotationProperty> {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = AnnotationPropertySearcher.selectTranslators(null);

    @Override
    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    @Override
    protected ONTObject<OWLAnnotationProperty> createEntity(String uri, OntModel model, ONTObjectFactory factory) {
        return factory.getProperty(OntApiException.mustNotBeNull(model.getAnnotationProperty(uri)));
    }

    @Override
    protected ONTObject<OWLAnnotationProperty> createEntity(String uri, ModelObjectFactory factory) {
        return factory.getAnnotationProperty(uri);
    }

    @Override
    protected Resource getEntityType() {
        return OWL.AnnotationProperty;
    }

    @Override
    protected Set<Node> getBuiltinsSpec(OntModel m) {
        return AnnotationPropertySearcher.getBuiltinsVocabulary(m).getAnnotationProperties();
    }

    @Override
    protected boolean containsInOntology(Resource uri, OntModel m, AxiomsSettings conf) {
        if (Iter.anyMatch(AnnotationPropertySearcher.listHeaderAnnotations(m).mapWith(Statement::getPredicate), arg_0 -> ((Resource)uri).equals(arg_0))) {
            return true;
        }
        return super.containsInOntology(uri, m, conf);
    }
}

