/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.searchers.ForClass;
import com.github.owlcs.ontapi.internal.searchers.objects.WithCardinality;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;

public class ClassSearcher
extends WithCardinality<OWLClass>
implements ForClass {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = ClassSearcher.selectTranslators(OWLComponentType.CLASS);

    @Override
    protected Resource getEntityType() {
        return OWL.Class;
    }

    @Override
    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    @Override
    protected ONTObject<OWLClass> createEntity(String uri, OntModel model, ONTObjectFactory factory) {
        return factory.getClass(OntApiException.mustNotBeNull(model.getOntClass(uri)));
    }

    @Override
    protected ONTObject<OWLClass> createEntity(String uri, ModelObjectFactory factory) {
        return factory.getClass(uri);
    }

    @Override
    protected ExtendedIterator<String> listEntities(OntModel model, AxiomsSettings conf) {
        Set<String> builtins = this.getModelBuiltins(model, conf);
        this.addTopEntity(builtins, model, conf);
        return this.listEntities(model, builtins, conf);
    }

    @Override
    protected Set<Node> getBuiltinsSpec(OntModel m) {
        return ClassSearcher.getBuiltinsVocabulary(m).getClasses();
    }
}

