/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.searchers.objects.PropertySearcher;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;

public class DataPropertySearcher
extends PropertySearcher<OWLDataProperty> {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = DataPropertySearcher.selectTranslators(OWLComponentType.DATATYPE_PROPERTY);

    @Override
    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    @Override
    protected ONTObject<OWLDataProperty> createEntity(String uri, OntModel model, ONTObjectFactory factory) {
        return factory.getProperty(OntApiException.mustNotBeNull(model.getDataProperty(uri)));
    }

    @Override
    protected ONTObject<OWLDataProperty> createEntity(String uri, ModelObjectFactory factory) {
        return factory.getDataProperty(uri);
    }

    @Override
    protected Resource getEntityType() {
        return OWL.DatatypeProperty;
    }

    @Override
    protected Set<Node> getBuiltinsSpec(OntModel m) {
        return DataPropertySearcher.getBuiltinsVocabulary(m).getDatatypeProperties();
    }
}

