/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.searchers.ForDatatype;
import com.github.owlcs.ontapi.internal.searchers.objects.WithCardinality;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;

public class DatatypeSearcher
extends WithCardinality<OWLDatatype>
implements ForDatatype {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = DatatypeSearcher.selectTranslators(null);

    private static OntDataRange.Named getDatatype(Statement statement, OntModel model) {
        Resource s = statement.getSubject();
        RDFNode o = statement.getObject();
        if (s.isURIResource() && RDF.type.equals(statement.getPredicate()) && RDFS.Datatype.equals((Object)o)) {
            return model.getDatatype(s.getURI());
        }
        if (o.isURIResource()) {
            return model.getDatatype(o.asResource().getURI());
        }
        if (!o.isLiteral()) {
            return null;
        }
        return DatatypeSearcher.getDatatype(o, model);
    }

    private static OntDataRange.Named getDatatype(RDFNode node, OntModel model) {
        if (!node.isLiteral()) {
            return null;
        }
        return model.getDatatype(node.asLiteral());
    }

    @Override
    protected Set<Node> getBuiltinsSpec(OntModel m) {
        return DatatypeSearcher.getBuiltinsVocabulary(m).getDatatypes();
    }

    @Override
    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    @Override
    protected Resource getEntityType() {
        return RDFS.Datatype;
    }

    @Override
    protected ONTObject<OWLDatatype> createEntity(String uri, OntModel model, ONTObjectFactory factory) {
        return factory.getDatatype(OntApiException.mustNotBeNull(model.getDatatype(uri)));
    }

    @Override
    protected ONTObject<OWLDatatype> createEntity(String uri, ModelObjectFactory factory) {
        return factory.getDatatype(uri);
    }

    @Override
    protected ExtendedIterator<String> listEntities(OntModel m, AxiomsSettings conf) {
        HashSet<String> res = new HashSet<String>();
        this.addToSet(res, m, conf);
        return Iter.create(res);
    }

    private void addToSet(Set<String> res, OntModel model, AxiomsSettings conf) {
        Set header = DatatypeSearcher.listHeaderAnnotations(model).toSet();
        this.listStatements(model).forEachRemaining(s -> this.addToSet(res, (OntStatement)s, header, model, conf));
        if (!model.independent()) {
            Set fromHeader = header.stream().map(s -> DatatypeSearcher.getDatatype(s.getObject(), model)).filter(Objects::nonNull).map(Resource::getURI).collect(Collectors.toSet());
            this.listSharedFromImports(model).filterDrop(res::contains).filterKeep(s -> fromHeader.contains(s) || this.containsInAxiom(this.toResource(model, (String)s), model, conf)).forEachRemaining(res::add);
        }
        this.addTopEntity(res, model, conf);
    }

    private void addToSet(Set<String> res, OntStatement statement, Set<? extends Statement> header, OntModel model, AxiomsSettings conf) {
        OntDataRange.Named d = DatatypeSearcher.getDatatype(statement, model);
        if (d == null) {
            return;
        }
        String uri = d.getURI();
        if (res.contains(uri)) {
            return;
        }
        Class<? extends OntClass.RestrictionCE<?>> type = ForDatatype.getSpecialDataRestrictionType(uri);
        if (type != null && statement.getSubject().canAs(type)) {
            return;
        }
        if (this.isInOntology(statement, header, model, conf)) {
            res.add(uri);
        }
    }

    @Override
    protected boolean containsInOntology(Resource candidate, OntModel model, AxiomsSettings conf) {
        return this.containsInOntology(candidate.getURI(), model, conf);
    }

    @Override
    protected boolean containsInOntology(String uri, OntModel model, AxiomsSettings conf) {
        Set header = DatatypeSearcher.listHeaderAnnotations(model).toSet();
        Class<? extends OntClass.RestrictionCE<?>> type = ForDatatype.getSpecialDataRestrictionType(uri);
        return Iter.anyMatch(this.listStatements(model), s -> {
            if (s.getObject().isURIResource() && uri.equals(s.getResource().getURI())) {
                return this.isInAxiom((OntStatement)s, model, conf);
            }
            if (!s.getObject().isLiteral()) {
                return false;
            }
            if (!uri.equals(s.getLiteral().getDatatypeURI())) {
                return false;
            }
            if (type != null && s.getSubject().canAs(type)) {
                return false;
            }
            return this.isInOntology((OntStatement)s, header, model, conf);
        });
    }

    private boolean isInOntology(OntStatement statement, Set<? extends Statement> header, OntModel model, AxiomsSettings conf) {
        if (header.contains(statement)) {
            return true;
        }
        return this.isInAxiom(statement, model, conf);
    }

    private boolean isInAxiom(OntStatement statement, OntModel model, AxiomsSettings conf) {
        return this.containsAxiom(Iter.create(this.getRootStatements(model, statement)), conf);
    }
}

