/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ObjectsSearcher;
import com.github.owlcs.ontapi.internal.searchers.WithRootStatement;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Optional;
import java.util.function.Function;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

abstract class EntitySearcher<E extends OWLEntity>
extends WithRootStatement
implements ObjectsSearcher<E> {
    EntitySearcher() {
    }

    static PersonalityModel asPersonalityModel(OntModel m) {
        return PersonalityModel.asPersonalityModel(m);
    }

    public static ExtendedIterator<OntStatement> listHeaderAnnotations(OntModel m) {
        return m.id().map(OntObject::getMainStatement).map(OntModels::listAllAnnotations).orElse(Iter.of());
    }

    @Override
    public final ExtendedIterator<ONTObject<E>> listONTObjects(OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        return this.listEntities(model, config).mapWith(this.createMapping(model, factory));
    }

    @Override
    public final boolean containsONTObject(E object, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        return this.containsEntity(object.getIRI().getIRIString(), model, config);
    }

    @Override
    public final Optional<ONTObject<E>> findONTObject(E object, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        String uri = object.getIRI().getIRIString();
        if (this.containsEntity(uri, model, config)) {
            return Optional.of(this.createONTEntity(uri, model, factory));
        }
        return Optional.empty();
    }

    protected abstract ExtendedIterator<String> listEntities(OntModel var1, AxiomsSettings var2);

    protected abstract boolean containsEntity(String var1, OntModel var2, AxiomsSettings var3);

    protected abstract ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators();

    protected abstract ONTObject<E> createEntity(String var1, OntModel var2, ONTObjectFactory var3);

    protected abstract ONTObject<E> createEntity(String var1, ModelObjectFactory var2);

    protected abstract Resource getEntityType();

    final ONTObject<E> createONTEntity(String uri, OntModel model, ONTObjectFactory factory) {
        if (factory instanceof ModelObjectFactory) {
            return this.createEntity(uri, (ModelObjectFactory)factory);
        }
        return this.createEntity(uri, model, factory);
    }

    final Function<String, ONTObject<E>> createMapping(OntModel model, ONTObjectFactory factory) {
        if (factory instanceof ModelObjectFactory) {
            ModelObjectFactory f = (ModelObjectFactory)factory;
            return uri -> this.createEntity((String)uri, f);
        }
        return uri -> this.createEntity((String)uri, model, factory);
    }

    protected final ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators(OntStatement statement, AxiomsSettings conf) {
        return this.listTranslators().filterKeep(t -> t.testStatement(statement, conf));
    }

    protected ExtendedIterator<String> listSharedFromImports(OntModel m) {
        return this.listFromImports(m).mapWith(Resource::getURI);
    }

    private ExtendedIterator<Resource> listFromImports(OntModel m) {
        ExtendedIterator<OntModel> imports = OntModels.listImports(m);
        return Iter.distinct(Iter.flatMap(imports, i -> i.listStatements(null, RDF.type, (RDFNode)this.getEntityType())).mapWith(Statement::getSubject).filterKeep(RDFNode::isURIResource));
    }

    protected boolean containsInOntology(String uri, OntModel m, AxiomsSettings conf) {
        return this.containsInOntology(this.toResource(m, uri), m, conf);
    }

    protected boolean containsInOntology(Resource uri, OntModel m, AxiomsSettings conf) {
        return this.containsInAxiom(uri, m, conf);
    }

    final boolean containsInAxiom(Resource uri, OntModel m, AxiomsSettings conf) {
        return this.containsAxiom(this.listRootStatements(m, uri), conf);
    }

    protected final boolean containsAxiom(ExtendedIterator<OntStatement> roots, AxiomsSettings conf) {
        return Iter.anyMatch(roots, s -> Iter.findFirst(this.listTranslators((OntStatement)s, conf)).isPresent());
    }

    protected ExtendedIterator<OntStatement> listRootStatements(OntModel m, Resource uri) {
        return Iter.concat(this.listBySubject(m, uri), Iter.flatMap(this.listByObject(m, (RDFNode)uri), s -> this.listRootStatements(m, (OntStatement)s)));
    }

    protected Resource toResource(OntModel m, String uri) {
        return m.getResource(uri);
    }

    final boolean containsDeclaration(Resource uri, OntModel m, AxiomsSettings conf) {
        Resource type = this.getEntityType();
        if (m.independent()) {
            return m.getBaseGraph().contains(uri.asNode(), RDF.type.asNode(), type.asNode());
        }
        if (!m.contains(uri, RDF.type, (RDFNode)type)) {
            return false;
        }
        return this.containsInAxiom(uri, m, conf);
    }
}

