/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.searchers.objects.EntitySearcher;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

public class NamedIndividualSearcher
extends EntitySearcher<OWLNamedIndividual> {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = NamedIndividualSearcher.selectTranslators(OWLComponentType.NAMED_INDIVIDUAL);

    @Override
    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    @Override
    protected ONTObject<OWLNamedIndividual> createEntity(String uri, OntModel model, ONTObjectFactory factory) {
        return factory.getIndividual(OntApiException.mustNotBeNull(model.getIndividual(uri)));
    }

    @Override
    protected ONTObject<OWLNamedIndividual> createEntity(String uri, ModelObjectFactory factory) {
        return factory.getNamedIndividual(uri);
    }

    @Override
    protected Resource getEntityType() {
        return OWL.NamedIndividual;
    }

    @Override
    protected ExtendedIterator<String> listEntities(OntModel m, AxiomsSettings conf) {
        ExtendedIterator<String> res = this.listIndividuals(m);
        if (!m.independent()) {
            res = Iter.concat(res, this.listSharedFromImports(m).filterKeep(x -> this.containsInOntology((String)x, m, conf)));
        }
        return res;
    }

    @Override
    protected ExtendedIterator<String> listSharedFromImports(OntModel m) {
        return Iter.distinct(Iter.flatMap(OntModels.listImports(m), this::listIndividuals));
    }

    @Override
    protected boolean containsEntity(String uri, OntModel m, AxiomsSettings conf) {
        OntIndividual.Named i = m.getIndividual(uri);
        if (i == null) {
            return false;
        }
        if (m.independent()) {
            return true;
        }
        return this.containsInOntology(i, m, conf);
    }

    protected ExtendedIterator<String> listIndividuals(OntModel model) {
        HashSet seen = new HashSet();
        PersonalityModel p = NamedIndividualSearcher.asPersonalityModel(model);
        Set<Node> system = NamedIndividualSearcher.getSystemResources(model);
        return model.getBaseGraph().find(Node.ANY, RDF.Nodes.type, Node.ANY).mapWith(t -> {
            if (!t.getSubject().isURI()) {
                return null;
            }
            Node type = t.getObject();
            if (OWL.NamedIndividual.asNode().equals((Object)type)) {
                return seen.remove(t) ? null : model.asStatement((Triple)t);
            }
            if (system.contains(type)) {
                return null;
            }
            if (seen.remove(t)) {
                return null;
            }
            if (p.findNodeAs(type, OntClass.class) == null) {
                return null;
            }
            return model.asStatement((Triple)t);
        }).filterKeep(s -> {
            if (s == null) {
                return false;
            }
            OntIndividual i = s.getSubject().getAs(OntIndividual.class);
            if (i == null) {
                return false;
            }
            Iter.concat(Iter.of(OWL.NamedIndividual), OntModels.listClasses(i)).forEachRemaining(x -> {
                if (s.getObject().equals(x)) {
                    return;
                }
                seen.add(Triple.create((Node)i.asNode(), (Node)RDF.Nodes.type, (Node)x.asNode()));
            });
            return true;
        }).mapWith(s -> s.getSubject().getURI());
    }
}

