/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.searchers.objects.PropertySearcher;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class ObjectPropertySearcher
extends PropertySearcher<OWLObjectProperty> {
    private static final Set<AxiomTranslator<OWLAxiom>> TRANSLATORS = ObjectPropertySearcher.selectTranslators(OWLComponentType.NAMED_OBJECT_PROPERTY);

    @Override
    protected ExtendedIterator<? extends AxiomTranslator<OWLAxiom>> listTranslators() {
        return Iter.create(TRANSLATORS);
    }

    @Override
    protected ONTObject<OWLObjectProperty> createEntity(String uri, OntModel model, ONTObjectFactory factory) {
        return factory.getProperty(OntApiException.mustNotBeNull(model.getObjectProperty(uri)));
    }

    @Override
    protected ONTObject<OWLObjectProperty> createEntity(String uri, ModelObjectFactory factory) {
        return factory.getObjectProperty(uri);
    }

    @Override
    protected Resource getEntityType() {
        return OWL.ObjectProperty;
    }

    @Override
    protected Set<Node> getBuiltinsSpec(OntModel m) {
        return ObjectPropertySearcher.getBuiltinsVocabulary(m).getObjectProperties();
    }
}

