/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.searchers.objects.WithBuiltins;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLProperty;

abstract class PropertySearcher<E extends OWLProperty>
extends WithBuiltins<E> {
    PropertySearcher() {
    }

    @Override
    protected ExtendedIterator<OntStatement> listRootStatements(OntModel m, Resource uri) {
        return Iter.concat(super.listRootStatements(m, uri), this.listByPredicate(m, (Property)uri));
    }

    protected Property toResource(OntModel m, String uri) {
        return m.getProperty(uri);
    }

    @Override
    protected ExtendedIterator<String> listEntities(OntModel m, AxiomsSettings conf) {
        return this.listEntities(m, this.getModelBuiltins(m, conf), conf);
    }

    @Override
    protected boolean containsEntity(String uri, OntModel m, AxiomsSettings conf) {
        Property p = this.toResource(m, uri);
        return this.isInBuiltinSpec(m, (FrontsNode)p) ? this.containsInOntology((Resource)p, m, conf) : this.containsDeclaration((Resource)p, m, conf);
    }
}

