/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.searchers.objects.EntitySearcher;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLEntity;

abstract class WithBuiltins<E extends OWLEntity>
extends EntitySearcher<E> {
    WithBuiltins() {
    }

    static OntPersonality.Builtins getBuiltinsVocabulary(OntModel m) {
        return WithBuiltins.asPersonalityModel(m).getOntPersonality().getBuiltins();
    }

    protected abstract Set<Node> getBuiltinsSpec(OntModel var1);

    protected Set<String> getModelBuiltins(OntModel m, AxiomsSettings conf) {
        HashSet<String> res = new HashSet<String>();
        this.getBuiltinsSpec(m).forEach(x -> {
            if (this.containsInOntology(x.getURI(), m, conf)) {
                res.add(x.getURI());
            }
        });
        return res;
    }

    protected boolean isInBuiltinSpec(OntModel m, FrontsNode node) {
        return this.getBuiltinsSpec(m).contains(node.asNode());
    }

    final ExtendedIterator<String> listEntities(OntModel m, Set<String> builtins, AxiomsSettings conf) {
        ExtendedIterator explicit = this.listByPredicateAndObject(m, RDF.type, (RDFNode)this.getEntityType()).mapWith(x -> x.getSubject().getURI()).filterKeep(x -> x != null && !builtins.contains(x));
        ExtendedIterator<String> res = Iter.concat(explicit, Iter.create(builtins));
        if (!m.independent()) {
            res = Iter.concat(res, this.listSharedFromImports(m).filterKeep(x -> this.containsInAxiom(this.toResource(m, (String)x), m, conf)));
        }
        return res;
    }
}

