/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.searchers.objects;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.searchers.ForTopEntity;
import com.github.owlcs.ontapi.internal.searchers.objects.WithBuiltins;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Set;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.OWLEntity;

abstract class WithCardinality<E extends OWLEntity>
extends WithBuiltins<E>
implements ForTopEntity {
    WithCardinality() {
    }

    private boolean containsCardinalityAxiom(OntModel model, AxiomsSettings conf) {
        return this.containsAxiom(Iter.flatMap(this.listImplicitStatements(model), s -> this.listRootStatements(model, (OntStatement)s)), conf);
    }

    protected void addTopEntity(Set<String> res, OntModel model, AxiomsSettings conf) {
        String uri = this.getTopEntityURI();
        if (res.contains(uri)) {
            return;
        }
        if (this.containsCardinalityAxiom(model, conf)) {
            res.add(uri);
        }
    }

    @Override
    protected final boolean containsEntity(String uri, OntModel model, AxiomsSettings conf) {
        Resource res = this.toResource(model, uri);
        if (!this.isInBuiltinSpec(model, (FrontsNode)res)) {
            return this.containsDeclaration(res, model, conf);
        }
        if (this.getTopEntity().equals((Object)res) && this.containsCardinalityAxiom(model, conf)) {
            return true;
        }
        return this.containsInOntology(res, model, conf);
    }
}

